package cn.twelvet.multilevel.cache.properties;

import cn.twelvet.multilevel.cache.enums.CaffeineStrength;

import java.time.Duration;

/**
 * Caffeine 相关配置
 *
 * @author twelvet
 */
public class CaffeineConfigProp {

	/**
	 * 访问后过期时间
	 */
	private Duration expireAfterAccess;

	/**
	 * 写入后过期时间
	 */
	private Duration expireAfterWrite;

	/**
	 * 写入后刷新时间
	 */
	private Duration refreshAfterWrite;

	/**
	 * 初始化大小
	 */
	private int initialCapacity;

	/**
	 * 最大缓存对象个数，超过此数量时之前放入的缓存将失效
	 */
	private long maximumSize;

	/**
	 * key 强度
	 */
	private CaffeineStrength keyStrength;

	/**
	 * value 强度
	 */
	private CaffeineStrength valueStrength;

	/**
	 * getExpireAfterAccess
	 * @return Duration
	 */
	public Duration getExpireAfterAccess() {
		return expireAfterAccess;
	}

	/**
	 * setExpireAfterAccess
	 * @param expireAfterAccess Duration
	 */
	public void setExpireAfterAccess(Duration expireAfterAccess) {
		this.expireAfterAccess = expireAfterAccess;
	}

	/**
	 * getExpireAfterWrite
	 * @return Duration
	 */
	public Duration getExpireAfterWrite() {
		return expireAfterWrite;
	}

	/**
	 * setExpireAfterWrite
	 * @param expireAfterWrite Duration
	 */
	public void setExpireAfterWrite(Duration expireAfterWrite) {
		this.expireAfterWrite = expireAfterWrite;
	}

	/**
	 * getRefreshAfterWrite
	 * @return Duration
	 */
	public Duration getRefreshAfterWrite() {
		return refreshAfterWrite;
	}

	/**
	 * setRefreshAfterWrite
	 * @param refreshAfterWrite Duration
	 */
	public void setRefreshAfterWrite(Duration refreshAfterWrite) {
		this.refreshAfterWrite = refreshAfterWrite;
	}

	/**
	 * getInitialCapacity
	 * @return int
	 */
	public int getInitialCapacity() {
		return initialCapacity;
	}

	/**
	 * setInitialCapacity
	 * @param initialCapacity int
	 */
	public void setInitialCapacity(int initialCapacity) {
		this.initialCapacity = initialCapacity;
	}

	/**
	 * getMaximumSize
	 * @return long
	 */
	public long getMaximumSize() {
		return maximumSize;
	}

	/**
	 * setMaximumSize
	 * @param maximumSize long
	 */
	public void setMaximumSize(long maximumSize) {
		this.maximumSize = maximumSize;
	}

	/**
	 * getKeyStrength
	 * @return CaffeineStrength
	 */
	public CaffeineStrength getKeyStrength() {
		return keyStrength;
	}

	/**
	 * setKeyStrength
	 * @param keyStrength CaffeineStrength
	 */
	public void setKeyStrength(CaffeineStrength keyStrength) {
		this.keyStrength = keyStrength;
	}

	/**
	 * getValueStrength
	 * @return CaffeineStrength
	 */
	public CaffeineStrength getValueStrength() {
		return valueStrength;
	}

	/**
	 * setValueStrength
	 * @param valueStrength CaffeineStrength
	 */
	public void setValueStrength(CaffeineStrength valueStrength) {
		this.valueStrength = valueStrength;
	}

}
