package cn.twelvet.multilevel.cache.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.HashSet;
import java.util.Set;

/**
 * @author twelvet
 * @version 1.0.0
 * <p>
 * 全局配置
 */
@ConfigurationProperties(prefix = "spring.cache.multi")
public class CacheConfigProperties {

	private Set<String> cacheNames = new HashSet<>();

	/**
	 * 是否存储空值，默认true，防止缓存穿透
	 */
	private boolean cacheNullValues = true;

	/**
	 * 是否动态根据cacheName创建Cache的实现，默认true
	 */
	private boolean dynamic = true;

	/**
	 * 缓存key的前缀
	 */
	private String cachePrefix;

	/**
	 * 当前节点id。来自当前节点的缓存更新通知不会被处理
	 */
	private Object serverId;

	@NestedConfigurationProperty
	private RedisConfigProp redis = new RedisConfigProp();

	@NestedConfigurationProperty
	private CaffeineConfigProp caffeine = new CaffeineConfigProp();

	/**
	 * getCacheNames
	 * @return Set
	 */
	public Set<String> getCacheNames() {
		return cacheNames;
	}

	/**
	 * setCacheNames
	 * @param cacheNames Set
	 */
	public void setCacheNames(Set<String> cacheNames) {
		this.cacheNames = cacheNames;
	}

	/**
	 * isCacheNullValues
	 * @return boolean
	 */
	public boolean isCacheNullValues() {
		return cacheNullValues;
	}

	/**
	 * setCacheNullValues
	 * @param cacheNullValues boolean
	 */
	public void setCacheNullValues(boolean cacheNullValues) {
		this.cacheNullValues = cacheNullValues;
	}

	/**
	 * isDynamic
	 * @return boolean
	 */
	public boolean isDynamic() {
		return dynamic;
	}

	/**
	 * setDynamic
	 * @param dynamic boolean
	 */
	public void setDynamic(boolean dynamic) {
		this.dynamic = dynamic;
	}

	/**
	 * getCachePrefix
	 * @return String
	 */
	public String getCachePrefix() {
		return cachePrefix;
	}

	/**
	 * setCachePrefix
	 * @param cachePrefix String
	 */
	public void setCachePrefix(String cachePrefix) {
		this.cachePrefix = cachePrefix;
	}

	/**
	 * getServerId
	 * @return Object
	 */
	public Object getServerId() {
		return serverId;
	}

	/**
	 * setServerId
	 * @param serverId Object
	 */
	public void setServerId(Object serverId) {
		this.serverId = serverId;
	}

	/**
	 * getRedis
	 * @return RedisConfigProp
	 */
	public RedisConfigProp getRedis() {
		return redis;
	}

	/**
	 * setRedis
	 * @param redis RedisConfigProp
	 */
	public void setRedis(RedisConfigProp redis) {
		this.redis = redis;
	}

	/**
	 * getCaffeine
	 * @return CaffeineConfigProp
	 */
	public CaffeineConfigProp getCaffeine() {
		return caffeine;
	}

	/**
	 * setCaffeine
	 * @param caffeine CaffeineConfigProp
	 */
	public void setCaffeine(CaffeineConfigProp caffeine) {
		this.caffeine = caffeine;
	}

}
