/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.multilevel.cache.util;

import cn.twelvet.multilevel.cache.util.IterUtil;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class TransCollection<F, T>
extends AbstractCollection<T> {
    private final Collection<F> fromCollection;
    private final Function<? super F, ? extends T> function;

    public TransCollection(Collection<F> fromCollection, Function<? super F, ? extends T> function) {
        this.fromCollection = Objects.requireNonNull(fromCollection);
        this.function = Objects.requireNonNull(function);
    }

    @Override
    public Iterator<T> iterator() {
        return IterUtil.trans(this.fromCollection.iterator(), this.function);
    }

    @Override
    public void clear() {
        this.fromCollection.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.fromCollection.isEmpty();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        this.fromCollection.forEach(f -> action.accept((T)this.function.apply(f)));
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        Objects.requireNonNull(filter);
        return this.fromCollection.removeIf((? super E element) -> filter.test((T)this.function.apply(element)));
    }

    @Override
    public int size() {
        return this.fromCollection.size();
    }
}

