/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.multilevel.cache.config;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.cache.support.NullValue;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@AutoConfiguration
@ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class})
public class CacheJackson2ObjectMapperBuilderCustomizer
implements Jackson2ObjectMapperBuilderCustomizer {
    public void customize(Jackson2ObjectMapperBuilder builder) {
        builder.mixIn(NullValue.class, UseTypeInfo.class);
        builder.deserializers(new JsonDeserializer[]{NullValueDeserializer.INSTANCE});
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    public static class UseTypeInfo {
    }

    public static class NullValueDeserializer
    extends StdDeserializer<NullValue> {
        public static final NullValueDeserializer INSTANCE = new NullValueDeserializer();

        protected NullValueDeserializer() {
            super(NullValue.class);
        }

        public NullValue deserialize(JsonParser p, DeserializationContext ctx) {
            return (NullValue)NullValue.INSTANCE;
        }
    }
}

