/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.multilevel.cache;

import cn.twelvet.multilevel.cache.properties.CacheConfigProperties;
import cn.twelvet.multilevel.cache.support.CacheMessageListener;
import cn.twelvet.multilevel.cache.support.RedisCaffeineCacheManager;
import cn.twelvet.multilevel.cache.support.RedisCaffeineCacheManagerCustomizer;
import cn.twelvet.multilevel.cache.support.RedisSequenceServerIdGenerator;
import cn.twelvet.multilevel.cache.support.ServerIdGenerator;
import java.util.Objects;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@AutoConfiguration(after={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={CacheConfigProperties.class})
public class MultilevelCacheAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={RedisTemplate.class})
    public RedisCaffeineCacheManager cacheManager(CacheConfigProperties cacheConfigProperties, @Qualifier(value="stringKeyRedisTemplate") RedisTemplate<Object, Object> stringKeyRedisTemplate, ObjectProvider<RedisCaffeineCacheManagerCustomizer> cacheManagerCustomizers, ObjectProvider<ServerIdGenerator> serverIdGenerators) {
        Object serverId = cacheConfigProperties.getServerId();
        if (serverId == null || "".equals(serverId)) {
            serverIdGenerators.ifAvailable(serverIdGenerator -> cacheConfigProperties.setServerId(serverIdGenerator.get()));
        }
        RedisCaffeineCacheManager cacheManager = new RedisCaffeineCacheManager(cacheConfigProperties, stringKeyRedisTemplate);
        cacheManagerCustomizers.orderedStream().forEach(customizer -> customizer.customize(cacheManager));
        return cacheManager;
    }

    @Bean
    @ConditionalOnMissingBean(name={"stringKeyRedisTemplate"})
    public RedisTemplate<Object, Object> stringKeyRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(name={"cacheMessageListenerContainer"})
    public RedisMessageListenerContainer cacheMessageListenerContainer(CacheConfigProperties cacheConfigProperties, @Qualifier(value="stringKeyRedisTemplate") RedisTemplate<Object, Object> stringKeyRedisTemplate, @Qualifier(value="cacheMessageListener") CacheMessageListener cacheMessageListener) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(Objects.requireNonNull(stringKeyRedisTemplate.getConnectionFactory()));
        redisMessageListenerContainer.addMessageListener((MessageListener)cacheMessageListener, (Topic)new ChannelTopic(cacheConfigProperties.getRedis().getTopic()));
        return redisMessageListenerContainer;
    }

    @Bean
    @ConditionalOnMissingBean(name={"cacheMessageListener"})
    public CacheMessageListener cacheMessageListener(@Qualifier(value="stringKeyRedisTemplate") RedisTemplate<Object, Object> stringKeyRedisTemplate, RedisCaffeineCacheManager redisCaffeineCacheManager) {
        return new CacheMessageListener((RedisSerializer<Object>)stringKeyRedisTemplate.getValueSerializer(), redisCaffeineCacheManager);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServerIdGenerator.class})
    public ServerIdGenerator redisSequenceServerIdGenerator(@Qualifier(value="stringKeyRedisTemplate") RedisTemplate<Object, Object> stringKeyRedisTemplate, CacheConfigProperties properties) {
        return new RedisSequenceServerIdGenerator(stringKeyRedisTemplate, properties);
    }
}

