/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.multilevel.cache.support;

import cn.twelvet.multilevel.cache.enums.CacheOperation;
import cn.twelvet.multilevel.cache.properties.CacheConfigProperties;
import cn.twelvet.multilevel.cache.support.CacheManager;
import cn.twelvet.multilevel.cache.support.RedisCaffeineCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCaffeineCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(RedisCaffeineCacheManager.class);
    private ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();
    private CacheConfigProperties cacheConfigProperties;
    private RedisTemplate<Object, Object> stringKeyRedisTemplate;
    private boolean dynamic;
    private Set<String> cacheNames;
    private Object serverId;

    public ConcurrentMap<String, Cache> getCacheMap() {
        return this.cacheMap;
    }

    public void setCacheMap(ConcurrentMap<String, Cache> cacheMap) {
        this.cacheMap = cacheMap;
    }

    public CacheConfigProperties getCacheConfigProperties() {
        return this.cacheConfigProperties;
    }

    public void setCacheConfigProperties(CacheConfigProperties cacheConfigProperties) {
        this.cacheConfigProperties = cacheConfigProperties;
    }

    public RedisTemplate<Object, Object> getStringKeyRedisTemplate() {
        return this.stringKeyRedisTemplate;
    }

    public void setStringKeyRedisTemplate(RedisTemplate<Object, Object> stringKeyRedisTemplate) {
        this.stringKeyRedisTemplate = stringKeyRedisTemplate;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setCacheNames(Set<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    public Object getServerId() {
        return this.serverId;
    }

    public void setServerId(Object serverId) {
        this.serverId = serverId;
    }

    public RedisCaffeineCacheManager(CacheConfigProperties cacheConfigProperties, RedisTemplate<Object, Object> stringKeyRedisTemplate) {
        this.cacheConfigProperties = cacheConfigProperties;
        this.stringKeyRedisTemplate = stringKeyRedisTemplate;
        this.dynamic = cacheConfigProperties.isDynamic();
        this.cacheNames = cacheConfigProperties.getCacheNames();
        this.serverId = cacheConfigProperties.getServerId();
    }

    public Cache getCache(String name) {
        Object cache = (Cache)this.cacheMap.get(name);
        if (cache != null) {
            return cache;
        }
        if (!this.dynamic && !this.cacheNames.contains(name)) {
            return null;
        }
        cache = this.createCache(name);
        Cache oldCache = this.cacheMap.putIfAbsent(name, (Cache)cache);
        log.debug("create cache instance, the cache name is : {}", (Object)name);
        return oldCache == null ? cache : oldCache;
    }

    @Override
    public <K, V> com.github.benmanes.caffeine.cache.Cache<K, V> getCaffeineCache(String name) {
        return (com.github.benmanes.caffeine.cache.Cache)this.getCache(name);
    }

    public RedisCaffeineCache createCache(String name) {
        return new RedisCaffeineCache(name, this.stringKeyRedisTemplate, this.caffeineCache(), this.cacheConfigProperties);
    }

    public com.github.benmanes.caffeine.cache.Cache<Object, Object> caffeineCache() {
        return this.caffeineCacheBuilder().build();
    }

    public Caffeine<Object, Object> caffeineCacheBuilder() {
        Caffeine cacheBuilder = Caffeine.newBuilder();
        RedisCaffeineCacheManager.doIfPresent(this.cacheConfigProperties.getCaffeine().getExpireAfterAccess(), arg_0 -> ((Caffeine)cacheBuilder).expireAfterAccess(arg_0));
        RedisCaffeineCacheManager.doIfPresent(this.cacheConfigProperties.getCaffeine().getExpireAfterWrite(), arg_0 -> ((Caffeine)cacheBuilder).expireAfterWrite(arg_0));
        RedisCaffeineCacheManager.doIfPresent(this.cacheConfigProperties.getCaffeine().getRefreshAfterWrite(), arg_0 -> ((Caffeine)cacheBuilder).refreshAfterWrite(arg_0));
        if (this.cacheConfigProperties.getCaffeine().getInitialCapacity() > 0) {
            cacheBuilder.initialCapacity(this.cacheConfigProperties.getCaffeine().getInitialCapacity());
        }
        if (this.cacheConfigProperties.getCaffeine().getMaximumSize() > 0L) {
            cacheBuilder.maximumSize(this.cacheConfigProperties.getCaffeine().getMaximumSize());
        }
        if (this.cacheConfigProperties.getCaffeine().getKeyStrength() != null) {
            switch (this.cacheConfigProperties.getCaffeine().getKeyStrength()) {
                case WEAK: {
                    cacheBuilder.weakKeys();
                    break;
                }
                case SOFT: {
                    throw new UnsupportedOperationException("caffeine \u4e0d\u652f\u6301 key \u8f6f\u5f15\u7528");
                }
            }
        }
        if (this.cacheConfigProperties.getCaffeine().getValueStrength() != null) {
            switch (this.cacheConfigProperties.getCaffeine().getValueStrength()) {
                case WEAK: {
                    cacheBuilder.weakValues();
                    break;
                }
                case SOFT: {
                    cacheBuilder.softValues();
                    break;
                }
            }
        }
        return cacheBuilder;
    }

    protected static void doIfPresent(Duration duration, Consumer<Duration> consumer) {
        if (duration != null && !duration.isNegative()) {
            consumer.accept(duration);
        }
    }

    public Collection<String> getCacheNames() {
        return this.cacheNames;
    }

    public void clearLocal(String cacheName, Object key) {
        this.clearLocal(cacheName, key, CacheOperation.EVICT);
    }

    public void clearLocal(String cacheName, Object key, CacheOperation operation) {
        Cache cache = (Cache)this.cacheMap.get(cacheName);
        if (cache == null) {
            return;
        }
        RedisCaffeineCache redisCaffeineCache = (RedisCaffeineCache)cache;
        if (CacheOperation.EVICT_BATCH.equals((Object)operation)) {
            redisCaffeineCache.clearLocalBatch((Iterable)key);
        } else {
            redisCaffeineCache.clearLocal(key);
        }
    }
}

