/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.multilevel.cache.support;

import cn.twelvet.multilevel.cache.enums.CacheOperation;
import cn.twelvet.multilevel.cache.properties.CacheConfigProperties;
import cn.twelvet.multilevel.cache.support.CacheMessage;
import cn.twelvet.multilevel.cache.util.CollUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.cache.support.NullValue;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RedisCaffeineCache
extends AbstractValueAdaptingCache
implements Cache<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(RedisCaffeineCache.class);
    private final String name;
    private final Cache<Object, Object> caffeineCache;
    private final RedisTemplate<Object, Object> stringKeyRedisTemplate;
    private final String cachePrefix;
    private final String getKeyPrefix;
    private final Duration defaultExpiration;
    private final Duration defaultNullValuesExpiration;
    private final Map<String, Duration> expires;
    private final String topic;
    private final Object serverId;
    private final Map<String, ReentrantLock> keyLockMap = new ConcurrentHashMap<String, ReentrantLock>();

    public String getName() {
        return this.name;
    }

    public Cache<Object, Object> getCaffeineCache() {
        return this.caffeineCache;
    }

    public RedisTemplate<Object, Object> getStringKeyRedisTemplate() {
        return this.stringKeyRedisTemplate;
    }

    public String getCachePrefix() {
        return this.cachePrefix;
    }

    public String getGetKeyPrefix() {
        return this.getKeyPrefix;
    }

    public Duration getDefaultExpiration() {
        return this.defaultExpiration;
    }

    public Duration getDefaultNullValuesExpiration() {
        return this.defaultNullValuesExpiration;
    }

    public Map<String, Duration> getExpires() {
        return this.expires;
    }

    public String getTopic() {
        return this.topic;
    }

    public Object getServerId() {
        return this.serverId;
    }

    public Map<String, ReentrantLock> getKeyLockMap() {
        return this.keyLockMap;
    }

    public RedisCaffeineCache(String name, RedisTemplate<Object, Object> stringKeyRedisTemplate, Cache<Object, Object> caffeineCache, CacheConfigProperties cacheConfigProperties) {
        super(cacheConfigProperties.isCacheNullValues());
        this.name = name;
        this.stringKeyRedisTemplate = stringKeyRedisTemplate;
        this.caffeineCache = caffeineCache;
        this.cachePrefix = cacheConfigProperties.getCachePrefix();
        this.getKeyPrefix = StringUtils.hasLength((String)this.cachePrefix) ? name + ":" + this.cachePrefix + ":" : name + ":";
        this.defaultExpiration = cacheConfigProperties.getRedis().getDefaultExpiration();
        this.defaultNullValuesExpiration = cacheConfigProperties.getRedis().getDefaultNullValuesExpiration();
        this.expires = cacheConfigProperties.getRedis().getExpires();
        this.topic = cacheConfigProperties.getRedis().getTopic();
        this.serverId = cacheConfigProperties.getServerId();
    }

    public Object getNativeCache() {
        return this;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.lookup(key);
        if (value != null) {
            return (T)value;
        }
        ReentrantLock lock = this.keyLockMap.computeIfAbsent(key.toString(), s -> {
            log.trace("create lock for key : {}", s);
            return new ReentrantLock();
        });
        try {
            lock.lock();
            value = this.lookup(key);
            if (value != null) {
                Object object = value;
                return (T)object;
            }
            value = valueLoader.call();
            Object storeValue = this.toStoreValue(value);
            this.put(key, storeValue);
            Object object = value;
            return (T)object;
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, e.getCause());
        }
        finally {
            lock.unlock();
        }
    }

    public void put(Object key, Object value) {
        if (!super.isAllowNullValues() && value == null) {
            this.evict(key);
            return;
        }
        this.doPut(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object prevValue;
        Object object = key;
        synchronized (object) {
            prevValue = this.getRedisValue(key);
            if (prevValue == null) {
                this.doPut(key, value);
            }
        }
        return this.toValueWrapper(prevValue);
    }

    private void doPut(Object key, Object value) {
        value = this.toStoreValue(value);
        Duration expire = this.getExpire(value);
        this.setRedisValue(key, value, expire);
        this.push(key);
        this.setCaffeineValue(key, value);
    }

    public void evict(Object key) {
        this.stringKeyRedisTemplate.delete(this.getKey(key));
        this.push(key);
        this.caffeineCache.invalidate(key);
    }

    public void clear() {
        Set keys = this.stringKeyRedisTemplate.keys((Object)this.name.concat(":*"));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.stringKeyRedisTemplate.delete((Collection)keys);
        }
        this.push((Object)null);
        this.caffeineCache.invalidateAll();
    }

    protected Object lookup(Object key) {
        Object cacheKey = this.getKey(key);
        Object value = this.getCaffeineValue(key);
        if (value != null) {
            log.debug("get cache from caffeine, the key is : {}", cacheKey);
            return value;
        }
        value = this.getRedisValue(key);
        if (value != null) {
            log.debug("get cache from redis and put in caffeine, the key is : {}", cacheKey);
            this.setCaffeineValue(key, value);
        }
        return value;
    }

    protected Object getKey(Object key) {
        return this.getKeyPrefix + key;
    }

    protected Duration getExpire(Object value) {
        Duration cacheNameExpire = this.expires.get(this.name);
        if (cacheNameExpire == null) {
            cacheNameExpire = this.defaultExpiration;
        }
        if ((value == null || value == NullValue.INSTANCE) && this.defaultNullValuesExpiration != null) {
            cacheNameExpire = this.defaultNullValuesExpiration;
        }
        return cacheNameExpire;
    }

    protected void push(Object key) {
        this.push(key, CacheOperation.EVICT);
    }

    protected void push(Object key, CacheOperation operation) {
        this.push(new CacheMessage(this.serverId, this.name, operation, key));
    }

    protected void push(CacheMessage message) {
        this.stringKeyRedisTemplate.convertAndSend(this.topic, (Object)message);
    }

    public void clearLocal(Object key) {
        log.debug("clear local cache, the key is : {}", key);
        if (key == null) {
            this.caffeineCache.invalidateAll();
        } else {
            this.caffeineCache.invalidate(key);
        }
    }

    public void clearLocalBatch(Iterable<Object> keys) {
        log.debug("clear local cache, the keys is : {}", keys);
        this.caffeineCache.invalidateAll(keys);
    }

    protected void setRedisValue(Object key, Object value, Duration expire) {
        this.setRedisValue(key, value, expire, (ValueOperations<Object, Object>)this.stringKeyRedisTemplate.opsForValue());
    }

    protected void setRedisValue(Object key, Object value, Duration expire, ValueOperations<Object, Object> valueOperations) {
        if (!expire.isNegative() && !expire.isZero()) {
            valueOperations.set(this.getKey(key), value, expire);
        } else {
            valueOperations.set(this.getKey(key), value);
        }
    }

    protected Object getRedisValue(Object key) {
        return this.stringKeyRedisTemplate.opsForValue().get(this.getKey(key));
    }

    protected void setCaffeineValue(Object key, Object value) {
        this.caffeineCache.put(key, value);
    }

    protected Object getCaffeineValue(Object key) {
        return this.caffeineCache.getIfPresent(key);
    }

    public @Nullable Object getIfPresent(@NonNull Object key) {
        Cache.ValueWrapper valueWrapper = this.get(key);
        if (valueWrapper == null) {
            return null;
        }
        return valueWrapper.get();
    }

    public @Nullable Object get(@NonNull Object key, @NonNull Function<? super Object, ?> mappingFunction) {
        return this.get(key, () -> mappingFunction.apply(key));
    }

    public @NonNull Map<@NonNull Object, @NonNull Object> getAllPresent(@NonNull Iterable<@NonNull ?> keys) {
        GetAllContext context = new GetAllContext(keys);
        this.doGetAll(context);
        Map<Object, Object> cachedKeyValues = context.cachedKeyValues;
        HashMap<Object, Object> result = new HashMap<Object, Object>(cachedKeyValues.size(), 1.0f);
        cachedKeyValues.forEach((k, v) -> result.put(k, this.fromStoreValue(v)));
        return result;
    }

    public @NonNull Map<Object, Object> getAll(@NonNull Iterable<?> keys, @NonNull Function<Iterable<?>, @NonNull Map<Object, Object>> mappingFunction) {
        GetAllContext context = new GetAllContext(keys);
        context.saveRedisAbsentKeys = true;
        this.doGetAll(context);
        int redisAbsentCount = context.redisAbsentCount;
        Map<Object, Object> cachedKeyValues = context.cachedKeyValues;
        if (redisAbsentCount == 0) {
            HashMap<Object, Object> result = new HashMap<Object, Object>(cachedKeyValues.size(), 1.0f);
            cachedKeyValues.forEach((k, v) -> result.put(k, this.fromStoreValue(v)));
            return result;
        }
        Map<Object, Object> mappingKeyValues = mappingFunction.apply(context.redisAbsentKeys);
        this.putAll(mappingKeyValues);
        HashMap<Object, Object> result = new HashMap<Object, Object>(cachedKeyValues.size() + mappingKeyValues.size(), 1.0f);
        cachedKeyValues.forEach((k, v) -> result.put(k, this.fromStoreValue(v)));
        result.putAll(mappingKeyValues);
        return result;
    }

    protected void doGetAll(GetAllContext context) {
        context.cachedKeyValues = this.caffeineCache.getAll(context.allKeys, keyIterable -> {
            Collection caffeineAbsentKeys = CollUtil.toCollection(keyIterable);
            Collection<Object> redisKeys = CollUtil.trans(caffeineAbsentKeys, this::getKey);
            List redisValues = this.stringKeyRedisTemplate.opsForValue().multiGet(redisKeys);
            Objects.requireNonNull(redisValues);
            int redisAbsentCount = 0;
            for (Object value : redisValues) {
                if (value != null) continue;
                ++redisAbsentCount;
            }
            context.redisAbsentCount = redisAbsentCount;
            HashMap result = new HashMap(caffeineAbsentKeys.size() - redisAbsentCount, 1.0f);
            boolean saveCacheAbsentKeys = context.saveRedisAbsentKeys;
            if (saveCacheAbsentKeys) {
                context.redisAbsentKeys = new HashSet<Object>(redisAbsentCount);
            }
            int index = 0;
            for (Object key : caffeineAbsentKeys) {
                Object redisValue = redisValues.get(index);
                if (redisValue != null) {
                    result.put(key, redisValue);
                } else if (saveCacheAbsentKeys) {
                    context.redisAbsentKeys.add(key);
                }
                ++index;
            }
            return result;
        });
    }

    public void putAll(final @NonNull Map<?, ?> map) {
        this.stringKeyRedisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(@NonNull RedisOperations<K, V> operations) throws DataAccessException {
                ValueOperations valueOperations = operations.opsForValue();
                map.forEach((k, v) -> {
                    Object o = RedisCaffeineCache.this.toStoreValue(v);
                    Duration expire = RedisCaffeineCache.this.getExpire(o);
                    RedisCaffeineCache.this.setRedisValue(k, o, expire, (ValueOperations<Object, Object>)valueOperations);
                    RedisCaffeineCache.this.setCaffeineValue(k, o);
                });
                return null;
            }
        });
        this.push(new ArrayList(map.keySet()), CacheOperation.EVICT_BATCH);
    }

    public void invalidate(@NonNull Object key) {
        this.evict(key);
    }

    public void invalidateAll(@NonNull Iterable<@NonNull ?> keys) {
        Collection<?> keysColl = CollUtil.toCollection(keys);
        Collection<Object> redisKeys = CollUtil.trans(keysColl, this::getKey);
        this.stringKeyRedisTemplate.delete(redisKeys);
        this.push(keysColl, CacheOperation.EVICT_BATCH);
        this.caffeineCache.invalidateAll(keysColl);
    }

    public void invalidateAll() {
        this.clear();
    }

    public @NonNegative long estimatedSize() {
        return this.caffeineCache.estimatedSize();
    }

    public @NonNull CacheStats stats() {
        return this.caffeineCache.stats();
    }

    public @NonNull ConcurrentMap<@NonNull Object, @NonNull Object> asMap() {
        return this.caffeineCache.asMap();
    }

    public void cleanUp() {
        this.caffeineCache.cleanUp();
    }

    public @NonNull Policy<Object, Object> policy() {
        return this.caffeineCache.policy();
    }

    protected static class GetAllContext {
        protected Iterable<Object> allKeys;
        protected boolean saveRedisAbsentKeys = false;
        protected Set<Object> redisAbsentKeys;
        protected int redisAbsentCount;
        protected Map<Object, Object> cachedKeyValues;

        public GetAllContext(Iterable<Object> allKeys) {
            this.allKeys = allKeys;
        }
    }
}

