/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.multilevel.cache.support;

import cn.twelvet.multilevel.cache.support.CacheMessage;
import cn.twelvet.multilevel.cache.support.RedisCaffeineCacheManager;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.serializer.RedisSerializer;

public class CacheMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RedisCaffeineCacheManager.class);
    private final RedisSerializer<Object> redisSerializer;
    private final RedisCaffeineCacheManager redisCaffeineCacheManager;

    public CacheMessageListener(RedisSerializer<Object> redisSerializer, RedisCaffeineCacheManager redisCaffeineCacheManager) {
        this.redisSerializer = redisSerializer;
        this.redisCaffeineCacheManager = redisCaffeineCacheManager;
    }

    public RedisSerializer<Object> getRedisSerializer() {
        return this.redisSerializer;
    }

    public RedisCaffeineCacheManager getRedisCaffeineCacheManager() {
        return this.redisCaffeineCacheManager;
    }

    public void onMessage(Message message, byte[] pattern) {
        CacheMessage cacheMessage = (CacheMessage)this.redisSerializer.deserialize(message.getBody());
        if (!Objects.equals(cacheMessage.getServerId(), this.redisCaffeineCacheManager.getServerId())) {
            log.debug("receive a redis topic message, clear local cache, the cacheName is {}, operation is {}, the key is {}", new Object[]{cacheMessage.getCacheName(), cacheMessage.getOperation(), cacheMessage.getKey()});
            this.redisCaffeineCacheManager.clearLocal(cacheMessage.getCacheName(), cacheMessage.getKey(), cacheMessage.getOperation());
        }
    }
}

