/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.excel.handler.response;

import cn.twelvet.excel.annotation.ResponseExcel;
import cn.twelvet.excel.annotation.Sheet;
import cn.twelvet.excel.config.ExcelConfigProperties;
import cn.twelvet.excel.converters.LocalDateStringConverter;
import cn.twelvet.excel.converters.LocalDateTimeStringConverter;
import cn.twelvet.excel.enhance.WriterBuilderEnhancer;
import cn.twelvet.excel.handler.response.SheetWriteHandler;
import cn.twelvet.excel.head.HeadGenerator;
import cn.twelvet.excel.head.HeadMeta;
import cn.twelvet.excel.head.impl.I18nHeaderCellWriteHandler;
import cn.twelvet.excel.kit.ExcelException;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaTypeFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class AbstractSheetWriteHandler
implements SheetWriteHandler,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractSheetWriteHandler.class);
    private final ExcelConfigProperties configProperties;
    private final ObjectProvider<List<Converter<?>>> converterProvider;
    private final WriterBuilderEnhancer excelWriterBuilderEnhance;
    private ApplicationContext applicationContext;
    private I18nHeaderCellWriteHandler i18nHeaderCellWriteHandler;

    public AbstractSheetWriteHandler(ExcelConfigProperties configProperties, ObjectProvider<List<Converter<?>>> converterProvider, WriterBuilderEnhancer excelWriterBuilderEnhance) {
        this.configProperties = configProperties;
        this.converterProvider = converterProvider;
        this.excelWriterBuilderEnhance = excelWriterBuilderEnhance;
    }

    public I18nHeaderCellWriteHandler getI18nHeaderCellWriteHandler() {
        return this.i18nHeaderCellWriteHandler;
    }

    public void setI18nHeaderCellWriteHandler(I18nHeaderCellWriteHandler i18nHeaderCellWriteHandler) {
        this.i18nHeaderCellWriteHandler = i18nHeaderCellWriteHandler;
    }

    @Override
    public void check(ResponseExcel responseExcel) {
        if (responseExcel.sheets().length == 0) {
            throw new ExcelException("@ResponseExcel sheet \u914d\u7f6e\u4e0d\u5408\u6cd5");
        }
    }

    @Override
    public void export(Object o, HttpServletResponse response, ResponseExcel responseExcel) {
        this.check(responseExcel);
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        String name = (String)Objects.requireNonNull(requestAttributes).getAttribute("__EXCEL_NAME_KEY__", 0);
        if (name == null) {
            name = UUID.randomUUID().toString();
        }
        String fileName = null;
        try {
            fileName = String.format("%s%s", URLEncoder.encode(name, "UTF-8"), responseExcel.suffix().getValue());
        }
        catch (UnsupportedEncodingException e) {
            throw new ExcelException("encode fail");
        }
        String contentType = MediaTypeFactory.getMediaType((String)fileName).map(MimeType::toString).orElse("application/vnd.ms-excel");
        response.setContentType(contentType);
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename*=utf-8''" + fileName);
        this.write(o, response, responseExcel);
    }

    public ExcelWriter getExcelWriter(HttpServletResponse response, ResponseExcel responseExcel) {
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6outputStream\u6d41\u5931\u8d25");
            throw new ExcelException("\u83b7\u53d6outputStream\u6d41\u5931\u8d25");
        }
        ExcelWriterBuilder writerBuilder = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream).registerConverter((Converter)LocalDateStringConverter.INSTANCE)).registerConverter((Converter)LocalDateTimeStringConverter.INSTANCE)).autoCloseStream(Boolean.valueOf(true)).excelType(responseExcel.suffix()).inMemory(Boolean.valueOf(responseExcel.inMemory()));
        if (StringUtils.hasText((String)responseExcel.password())) {
            writerBuilder.password(responseExcel.password());
        }
        if (responseExcel.include().length != 0) {
            writerBuilder.includeColumnFieldNames(Arrays.asList(responseExcel.include()));
        }
        if (responseExcel.exclude().length != 0) {
            writerBuilder.excludeColumnFieldNames(Arrays.asList(responseExcel.exclude()));
        }
        for (Class<? extends WriteHandler> clazz : responseExcel.writeHandler()) {
            writerBuilder.registerWriteHandler((WriteHandler)BeanUtils.instantiateClass(clazz));
        }
        if (responseExcel.i18nHeader() && this.i18nHeaderCellWriteHandler != null) {
            writerBuilder.registerWriteHandler((WriteHandler)this.i18nHeaderCellWriteHandler);
        }
        this.registerCustomConverter(writerBuilder);
        for (Class<? extends WriteHandler> clazz : responseExcel.converter()) {
            writerBuilder.registerConverter((Converter)BeanUtils.instantiateClass(clazz));
        }
        String templatePath = this.configProperties.getTemplatePath();
        if (StringUtils.hasText((String)responseExcel.template())) {
            ClassPathResource classPathResource = new ClassPathResource(templatePath + File.separator + responseExcel.template());
            InputStream inputStream = null;
            try {
                inputStream = classPathResource.getInputStream();
            }
            catch (IOException iOException) {
                log.error("\u83b7\u53d6inputStream\u6d41\u5931\u8d25", (Throwable)iOException);
                throw new ExcelException("\u83b7\u53d6inputStream\u6d41\u5931\u8d25");
            }
            writerBuilder.withTemplate(inputStream);
        }
        writerBuilder = this.excelWriterBuilderEnhance.enhanceExcel(writerBuilder, response, responseExcel, templatePath);
        return writerBuilder.build();
    }

    public void registerCustomConverter(ExcelWriterBuilder builder) {
        this.converterProvider.ifAvailable(converters -> converters.forEach(arg_0 -> ((ExcelWriterBuilder)builder).registerConverter(arg_0)));
    }

    public WriteSheet sheet(Sheet sheet, Class<?> dataClass, String template, Class<? extends HeadGenerator> bookHeadEnhancerClass) {
        Integer sheetNo = sheet.sheetNo() >= 0 ? Integer.valueOf(sheet.sheetNo()) : null;
        String sheetName = sheet.sheetName();
        ExcelWriterSheetBuilder writerSheetBuilder = StringUtils.hasText((String)template) ? EasyExcel.writerSheet((Integer)sheetNo) : EasyExcel.writerSheet((Integer)sheetNo, (String)sheetName);
        Class<? extends HeadGenerator> headGenerateClass = null;
        if (this.isNotInterface(sheet.headGenerateClass())) {
            headGenerateClass = sheet.headGenerateClass();
        } else if (this.isNotInterface(bookHeadEnhancerClass)) {
            headGenerateClass = bookHeadEnhancerClass;
        }
        if (headGenerateClass != null) {
            this.fillCustomHeadInfo(dataClass, bookHeadEnhancerClass, writerSheetBuilder);
        } else if (dataClass != null) {
            writerSheetBuilder.head(dataClass);
            if (sheet.excludes().length > 0) {
                writerSheetBuilder.excludeColumnFieldNames(Arrays.asList(sheet.excludes()));
            }
            if (sheet.includes().length > 0) {
                writerSheetBuilder.includeColumnFieldNames(Arrays.asList(sheet.includes()));
            }
        }
        writerSheetBuilder = this.excelWriterBuilderEnhance.enhanceSheet(writerSheetBuilder, sheetNo, sheetName, dataClass, template, headGenerateClass);
        return writerSheetBuilder.build();
    }

    private void fillCustomHeadInfo(Class<?> dataClass, Class<? extends HeadGenerator> headEnhancerClass, ExcelWriterSheetBuilder writerSheetBuilder) {
        HeadGenerator headGenerator = (HeadGenerator)this.applicationContext.getBean(headEnhancerClass);
        Assert.notNull((Object)headGenerator, (String)"The header generated bean does not exist.");
        HeadMeta head = headGenerator.head(dataClass);
        writerSheetBuilder.head(head.getHead());
        writerSheetBuilder.excludeColumnFieldNames(head.getIgnoreHeadFields());
    }

    private boolean isNotInterface(Class<? extends HeadGenerator> headGeneratorClass) {
        return !Modifier.isInterface(headGeneratorClass.getModifiers());
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

