/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.excel.converters;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public enum LocalDateTimeStringConverter implements Converter<LocalDateTime>
{
    INSTANCE;

    private static final String MINUS = "-";

    public Class supportJavaTypeKey() {
        return LocalDateTime.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public LocalDateTime convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws ParseException {
        String stringValue = cellData.getStringValue();
        String pattern = contentProperty == null || contentProperty.getDateTimeFormatProperty() == null ? LocalDateTimeStringConverter.switchDateFormat(stringValue) : contentProperty.getDateTimeFormatProperty().getFormat();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(cellData.getStringValue(), formatter);
    }

    public WriteCellData<String> convertToExcelData(LocalDateTime value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String pattern = contentProperty == null || contentProperty.getDateTimeFormatProperty() == null ? "yyyy-MM-dd HH:mm:ss" : contentProperty.getDateTimeFormatProperty().getFormat();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return new WriteCellData(value.format(formatter));
    }

    private static String switchDateFormat(String dateString) {
        int length = dateString.length();
        switch (length) {
            case 19: {
                if (dateString.contains(MINUS)) {
                    return "yyyy-MM-dd HH:mm:ss";
                }
                return "yyyy/MM/dd HH:mm:ss";
            }
            case 17: {
                return "yyyyMMdd HH:mm:ss";
            }
            case 14: {
                return "yyyyMMddHHmmss";
            }
            case 10: {
                return "yyyy-MM-dd";
            }
        }
        throw new IllegalArgumentException("can not find date format for\uff1a" + dateString);
    }
}

