/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.excel.aop;

import cn.twelvet.excel.annotation.RequestExcel;
import cn.twelvet.excel.converters.LocalDateStringConverter;
import cn.twelvet.excel.converters.LocalDateTimeStringConverter;
import cn.twelvet.excel.handler.request.ListAnalysisEventListener;
import cn.twelvet.excel.kit.ExcelException;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.NonNull;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

public class RequestExcelArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(RequestExcelArgumentResolver.class);

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestExcel.class);
    }

    public Object resolveArgument(@NonNull MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, @NonNull NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) {
        try {
            Object inputStream;
            Class parameterType = methodParameter.getParameterType();
            if (!parameterType.isAssignableFrom(List.class)) {
                throw new IllegalArgumentException("Excel upload request resolver error, @RequestExcel parameter is not List " + parameterType);
            }
            RequestExcel requestExcel = (RequestExcel)methodParameter.getParameterAnnotation(RequestExcel.class);
            assert (requestExcel != null);
            Class<? extends ListAnalysisEventListener<?>> readListenerClass = requestExcel.readListener();
            ListAnalysisEventListener readListener = (ListAnalysisEventListener)((Object)BeanUtils.instantiateClass(readListenerClass));
            HttpServletRequest request = (HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class);
            assert (request != null);
            if (request instanceof MultipartRequest) {
                MultipartFile file = ((MultipartRequest)request).getFile(requestExcel.fileName());
                assert (file != null);
                inputStream = file.getInputStream();
            } else {
                inputStream = request.getInputStream();
            }
            Class excelModelClass = ResolvableType.forMethodParameter((MethodParameter)methodParameter).getGeneric(new int[]{0}).resolve();
            ((ExcelReaderSheetBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, (Class)excelModelClass, (ReadListener)readListener).registerConverter((Converter)LocalDateStringConverter.INSTANCE)).registerConverter((Converter)LocalDateTimeStringConverter.INSTANCE)).ignoreEmptyRow(Boolean.valueOf(requestExcel.ignoreEmptyRow())).sheet().headRowNumber(Integer.valueOf(requestExcel.headRowNumber()))).doRead();
            WebDataBinder dataBinder = webDataBinderFactory.createBinder(nativeWebRequest, readListener.getErrors(), "excel");
            ModelMap model = modelAndViewContainer.getModel();
            model.put((Object)(BindingResult.MODEL_KEY_PREFIX + "excel"), (Object)dataBinder.getBindingResult());
            return readListener.getList();
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165Excel\u5931\u8d25", (Throwable)e);
            throw new ExcelException("\u5bfc\u5165Excel\u5931\u8d25");
        }
    }
}

