/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.excel.aop;

import cn.twelvet.excel.annotation.ResponseExcel;
import cn.twelvet.excel.processor.NameProcessor;
import java.time.LocalDateTime;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
public class DynamicNameAspect {
    public static final String EXCEL_NAME_KEY = "__EXCEL_NAME_KEY__";
    private final NameProcessor processor;

    public DynamicNameAspect(NameProcessor processor) {
        this.processor = processor;
    }

    @Before(value="@annotation(responseExcel)")
    public void around(JoinPoint point, ResponseExcel responseExcel) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        String name = responseExcel.name();
        name = !StringUtils.hasText((String)name) ? LocalDateTime.now().toString() : this.processor.doDetermineName(point.getArgs(), ms.getMethod(), responseExcel.name());
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Objects.requireNonNull(requestAttributes).setAttribute(EXCEL_NAME_KEY, (Object)name, 0);
    }
}

