/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.excel;

import cn.twelvet.excel.ExcelHandlerConfiguration;
import cn.twelvet.excel.aop.DynamicNameAspect;
import cn.twelvet.excel.aop.RequestExcelArgumentResolver;
import cn.twelvet.excel.aop.ResponseExcelReturnValueHandler;
import cn.twelvet.excel.config.ExcelConfigProperties;
import cn.twelvet.excel.processor.NameProcessor;
import cn.twelvet.excel.processor.impl.NameSpelExpressionProcessorImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@AutoConfiguration
@Import(value={ExcelHandlerConfiguration.class})
@EnableConfigurationProperties(value={ExcelConfigProperties.class})
public class ResponseExcelAutoConfiguration {
    private final RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private final ResponseExcelReturnValueHandler responseExcelReturnValueHandler;

    public ResponseExcelAutoConfiguration(RequestMappingHandlerAdapter requestMappingHandlerAdapter, ResponseExcelReturnValueHandler responseExcelReturnValueHandler) {
        this.requestMappingHandlerAdapter = requestMappingHandlerAdapter;
        this.responseExcelReturnValueHandler = responseExcelReturnValueHandler;
    }

    @Bean
    @ConditionalOnMissingBean
    public NameProcessor nameProcessor() {
        return new NameSpelExpressionProcessorImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicNameAspect dynamicNameAspect(NameProcessor nameProcessor) {
        return new DynamicNameAspect(nameProcessor);
    }

    public void addReturnValueHandlers() {
        List returnValueHandlers = this.requestMappingHandlerAdapter.getReturnValueHandlers();
        ArrayList<ResponseExcelReturnValueHandler> handlerMethodReturnValueHandlers = new ArrayList<ResponseExcelReturnValueHandler>();
        handlerMethodReturnValueHandlers.add(this.responseExcelReturnValueHandler);
        assert (returnValueHandlers != null);
        handlerMethodReturnValueHandlers.addAll(returnValueHandlers);
        this.requestMappingHandlerAdapter.setReturnValueHandlers(handlerMethodReturnValueHandlers);
    }

    public void addRequestExcelArgumentResolver() {
        List argumentResolvers = this.requestMappingHandlerAdapter.getArgumentResolvers();
        ArrayList<RequestExcelArgumentResolver> handlerMethodArgumentResolvers = new ArrayList<RequestExcelArgumentResolver>();
        handlerMethodArgumentResolvers.add(new RequestExcelArgumentResolver());
        assert (argumentResolvers != null);
        handlerMethodArgumentResolvers.addAll(argumentResolvers);
        this.requestMappingHandlerAdapter.setArgumentResolvers(handlerMethodArgumentResolvers);
    }

    @PostConstruct
    public void addHandlers() {
        this.addReturnValueHandlers();
        this.addRequestExcelArgumentResolver();
    }
}

