/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.excel;

import cn.twelvet.excel.aop.ResponseExcelReturnValueHandler;
import cn.twelvet.excel.config.ExcelConfigProperties;
import cn.twelvet.excel.enhance.WriterBuilderEnhancer;
import cn.twelvet.excel.enhance.impl.DefaultWriterBuilderEnhancerImpl;
import cn.twelvet.excel.handler.response.SheetWriteHandler;
import cn.twelvet.excel.handler.response.impl.ManySheetWriteHandlerImpl;
import cn.twelvet.excel.handler.response.impl.SingleSheetWriteHandlerImpl;
import cn.twelvet.excel.head.impl.I18nHeaderCellWriteHandler;
import com.alibaba.excel.converters.Converter;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;

public class ExcelHandlerConfiguration {
    private final ExcelConfigProperties configProperties;
    private final ObjectProvider<List<Converter<?>>> converterProvider;

    public ExcelHandlerConfiguration(ExcelConfigProperties configProperties, ObjectProvider<List<Converter<?>>> converterProvider) {
        this.configProperties = configProperties;
        this.converterProvider = converterProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public WriterBuilderEnhancer writerBuilderEnhancer() {
        return new DefaultWriterBuilderEnhancerImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public SingleSheetWriteHandlerImpl singleSheetWriteHandler() {
        return new SingleSheetWriteHandlerImpl(this.configProperties, this.converterProvider, this.writerBuilderEnhancer());
    }

    @Bean
    @ConditionalOnMissingBean
    public ManySheetWriteHandlerImpl manySheetWriteHandler() {
        return new ManySheetWriteHandlerImpl(this.configProperties, this.converterProvider, this.writerBuilderEnhancer());
    }

    @Bean
    @ConditionalOnMissingBean
    public ResponseExcelReturnValueHandler responseExcelReturnValueHandler(List<SheetWriteHandler> sheetWriteHandlerList) {
        return new ResponseExcelReturnValueHandler(sheetWriteHandlerList);
    }

    @Bean
    @ConditionalOnBean(value={MessageSource.class})
    @ConditionalOnMissingBean
    public I18nHeaderCellWriteHandler i18nHeaderCellWriteHandler(MessageSource messageSource) {
        return new I18nHeaderCellWriteHandler(messageSource);
    }
}

