package cn.twelvet.excel.vo;

import java.util.HashSet;
import java.util.Set;

/**
 * 校验错误信息
 *
 * @author twelvet
 */
public class ErrorMessage {

	/**
	 * 行号
	 */
	private Long lineNum;

	/**
	 * 错误信息
	 */
	private Set<String> errors = new HashSet<>();

	/**
	 * @param errors 错误信息
	 */
	public ErrorMessage(Set<String> errors) {
		this.errors = errors;
	}

	/**
	 * ErrorMessage
	 * @param lineNum Long
	 * @param errors Set
	 */
	public ErrorMessage(Long lineNum, Set<String> errors) {
		this.lineNum = lineNum;
		this.errors = errors;
	}

	/**
	 * ErrorMessage
	 */
	public ErrorMessage() {
	}

	/**
	 * @param error 错误信息
	 */
	public ErrorMessage(String error) {
		HashSet<String> objects = new HashSet<>();
		objects.add(error);
		this.errors = objects;
	}

	/**
	 * getLineNum
	 * @return Long
	 */
	public Long getLineNum() {
		return lineNum;
	}

	/**
	 * setLineNum
	 * @param lineNum Long
	 */
	public void setLineNum(Long lineNum) {
		this.lineNum = lineNum;
	}

	/**
	 * getErrors
	 * @return Set
	 */
	public Set<String> getErrors() {
		return errors;
	}

	/**
	 * setErrors
	 * @param errors Set
	 */
	public void setErrors(Set<String> errors) {
		this.errors = errors;
	}

}
