package cn.twelvet.excel.head;

import java.util.List;
import java.util.Set;

/**
 * 头部信息
 *
 * @author twelvet
 */
public class HeadMeta {

	/**
	 * 自定义头部信息
	 * <p>
	 * 实现类根据数据的class信息，定制Excel头 具体方法使用参考：<a href=
	 * "https://easyexcel.opensource.alibaba.com/docs/current/quickstart/write">写Excel</a>
	 */
	private List<List<String>> head;

	/**
	 * 忽略头对应字段名称
	 */
	private Set<String> ignoreHeadFields;

	/**
	 * getHead
	 * @return List
	 */
	public List<List<String>> getHead() {
		return head;
	}

	/**
	 * setHead
	 * @param head List
	 */
	public void setHead(List<List<String>> head) {
		this.head = head;
	}

	/**
	 * getIgnoreHeadFields
	 * @return Set
	 */
	public Set<String> getIgnoreHeadFields() {
		return ignoreHeadFields;
	}

	/**
	 * setIgnoreHeadFields
	 * @param ignoreHeadFields Set
	 */
	public void setIgnoreHeadFields(Set<String> ignoreHeadFields) {
		this.ignoreHeadFields = ignoreHeadFields;
	}

	@Override
	public String toString() {
		return "HeadMeta{" + "head=" + head + ", ignoreHeadFields=" + ignoreHeadFields + '}';
	}

}
