package cn.twelvet.excel.annotation;

import cn.twelvet.excel.head.HeadGenerator;

import java.lang.annotation.*;

/**
 * Sheet
 *
 * @author twelvet
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Sheet {

	/**
	 * 号数
	 * @return int
	 */
	int sheetNo() default -1;

	/**
	 * sheet name
	 * @return String
	 */
	String sheetName();

	/**
	 * 包含字段
	 * @return String[]
	 */
	String[] includes() default {};

	/**
	 * 排除字段
	 * @return String[]
	 */
	String[] excludes() default {};

	/**
	 * 头生成器
	 * @return Class
	 */
	Class<? extends HeadGenerator> headGenerateClass() default HeadGenerator.class;

}
