package cn.twelvet.excel.annotation;

import cn.twelvet.excel.constants.ExcelConstants;
import cn.twelvet.excel.handler.request.DefaultAnalysisEventListener;
import cn.twelvet.excel.handler.request.ListAnalysisEventListener;

import java.lang.annotation.*;

/**
 * 导入excel
 *
 * @author twelvet
 */
@Documented
@Target({ ElementType.PARAMETER })
@Retention(RetentionPolicy.RUNTIME)
public @interface RequestExcel {

	/**
	 * 前端上传字段名称 file
	 * @return String
	 */
	String fileName() default ExcelConstants.REQUEST_FILE_NAME;

	/**
	 * 读取的监听器类
	 * @return readListener
	 */
	Class<? extends ListAnalysisEventListener<?>> readListener() default DefaultAnalysisEventListener.class;

	/**
	 * 是否跳过空行
	 * @return 默认跳过
	 */
	boolean ignoreEmptyRow() default false;

	/**
	 * 读取的标题行数
	 * @return int
	 */
	int headRowNumber() default 1;

}
