package cn.meteor.system.client;// Copyright (C), Created on 2021-04-16

import cn.meteor.common.model.R;
import cn.meteor.common.model.UserInfo;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Feign失败配置
 *
 * @author ths
 * @since 1.0.0
 */
@Component
public class IUserClientFallback implements IUserClient {

	@Override
	public R<UserInfo> userInfoByToken(String token) {
		return R.failure("未获取到账号信息");
	}

	@Override
	public R<String> emailLogin(String email, String password) {
		return R.failure("登录失败");
	}

	@Override
	public R<List<Long>> getUserIdsByDeptIds(List<Long> deptIds) {
		return R.failure("查询失败");
	}

	@Override
	public R<List<UserInfo>> getUsersByDeptIds(List<Long> deptIds) {
		return R.failure("查询失败");
	}
}
