package cn.meteor.system.client;// Copyright (C), Created on 2021-04-16

import cn.meteor.common.launch.constants.AppConstants;
import cn.meteor.common.model.R;
import cn.meteor.common.model.UserInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * User Feign接口类
 *
 * @author ths
 * @since 1.0.0
 */
@FeignClient(
	name = AppConstants.APP_SYSTEM_NAME,
	contextId = "userClient",
	path = "/user",
	fallback = IUserClientFallback.class
)
public interface IUserClient {

	/**
	 * 根据token获取用户信息
	 *
	 * @param token token
	 * @return 用户信息
	 */
	@GetMapping(value = "userInfoByToken", produces = MediaType.APPLICATION_JSON_VALUE)
	R<UserInfo> userInfoByToken(@RequestParam("token") String token);

	/**
	 * 根据email/账户登录
	 *
	 * @param email email
	 * @param password password
	 * @return token
	 */
	@GetMapping(value = "emailLogin", produces = MediaType.APPLICATION_JSON_VALUE)
	R<String> emailLogin(@RequestParam("email") String email, @RequestParam("password") String password);

	/**
	 * 根据 部门ID集合 获取 用户ID集合
	 *
	 * @param deptIds 部门ID集合
	 * @return 用户ID集合
	 */
	@GetMapping(value = "getUserIdsByDeptIds", produces = MediaType.APPLICATION_JSON_VALUE)
	R<List<Long>> getUserIdsByDeptIds(@RequestParam("deptIds") List<Long> deptIds);

	/**
	 * 根据 部门ID递归 获取 用户集合
	 *
	 * @param deptIds 部门ID集合
	 * @return 用户ID集合
	 */
	@GetMapping(value = "getUsersByDeptIds", produces = MediaType.APPLICATION_JSON_VALUE)
	R<List<UserInfo>> getUsersByDeptIds(@RequestParam("deptIds") List<Long> deptIds);

}
