package cn.meteor.perf.engine.data;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 测试任务
 *
 * @author ths
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TestTaskData {

	/** 测试任务ID */
	private Long id;
	/** 测试任务名称 */
	private String name;
	/** 测试任务配置参数 */
	private TestTaskConfigData config;
	/** 任务步骤 */
	private List<TestTaskStepData> steps;
	/** 前置处理：只在压测前执行一次 */
	private List<TestTaskStepData> preSteps;
	/** 后置处理：只在压测后执行一次 */
	private List<TestTaskStepData> postSteps;

}
