package cn.meteor.perf.engine.data;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.util.MultiValueMap;

import java.util.Map;

/**
 * HTTP请求
 *
 * @author ths
 */
@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class HttpRequestData extends RequestData {

	/** 请求域名：如 https://www.baidu.com:443 */
	private String domain;
	/** 请求接口地址 */
	private String path;
	/** 请求方法 */
	private String reqMethod;
	/** 内容类型 */
	private String contentType;
	/** 请求头 */
	private MultiValueMap<String, String> headers;
	/** QUERY参数 */
	private MultiValueMap<String, String> reqQuery;
	/** 请求体 */
	private Map<String, Object> reqBody;
}
