package cn.meteor.perf.client;// Copyright (C), Created on 2021-04-16

import cn.hutool.json.JSONObject;
import cn.meteor.common.model.R;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * User Feign接口类
 *
 * @author ths
 * @since 1.0.0
 */
@FeignClient(
	name = "meteor-perf-client",
	contextId = "JmeterClient",
	path = "/"
)
public interface IJmeterClient {

	/**
	 * 执行 jmeter 程序（异步）
	 *
	 * @param data 测试任务数据
	 * @return 成功/失败
	 */
	@PostMapping(value = "exec", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	R<String> exec(@RequestBody JSONObject data);

}
