package cn.meteor.common.core.properties;// Copyright (C), Created on 2021-04-02

import cn.hutool.core.util.StrUtil;
import org.springframework.core.env.PropertySource;

import java.util.Properties;

/**
 * Properties 工具类
 *
 * @author ths
 * @since 1.0.0
 */
public class PropertiesUtil {

	/**
	 * 设置配置值，已存在则跳过
	 *
	 * @param props property
	 * @param key   key
	 * @param value value
	 */
	public static void setProperty(Properties props, String key, String value) {
		if (StrUtil.isEmpty(props.getProperty(key))) {
			props.setProperty(key, value);
		}
	}

	/**
	 * 设置配置值，已存在则跳过
	 *
	 * @param props          属性
	 * @param propertySource propertySource
	 * @param key            key
	 * @param value          value
	 */
	public static void setProperty(Properties props, PropertySource<?> propertySource, String key, String value) {
		if (propertySource == null || !propertySource.containsProperty(key)) {
			props.setProperty(key, value);
		}
	}
}
