/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.core.yaml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferUtil {
    private static final Logger log = LoggerFactory.getLogger(TransferUtil.class);

    public static Properties yaml2Properties(String path) {
        return TransferUtil.yaml2Properties(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties yaml2Properties(String path, boolean classpath) {
        Properties props = new Properties();
        YAMLParser parser = null;
        try {
            YAMLFactory yamlFactory = new YAMLFactory();
            parser = classpath ? yamlFactory.createParser(TransferUtil.class.getClassLoader().getResourceAsStream(path)) : yamlFactory.createParser((Reader)new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
            StringBuilder key = new StringBuilder();
            JsonToken token = parser.nextToken();
            while (token != null) {
                int dotOffset;
                if (JsonToken.FIELD_NAME.equals((Object)token)) {
                    if (key.length() > 0) {
                        key.append(".");
                    }
                    key.append(parser.getCurrentName());
                    token = parser.nextToken();
                    if (JsonToken.START_OBJECT.equals((Object)token)) continue;
                    String value = parser.getText();
                    props.setProperty(key.toString(), value);
                    dotOffset = key.toString().lastIndexOf(".");
                    if (dotOffset > 0) {
                        key = new StringBuilder(key.substring(0, dotOffset));
                    }
                } else if (JsonToken.END_OBJECT.equals((Object)token)) {
                    dotOffset = key.toString().lastIndexOf(".");
                    key = dotOffset > 0 ? new StringBuilder(key.substring(0, dotOffset)) : new StringBuilder();
                }
                token = parser.nextToken();
            }
        }
        catch (Exception e) {
            log.error("Yaml \u8f6c Properties\u65f6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    public static void properties2Yaml(String path, String targetPath) throws IOException {
        JavaPropsFactory factory = new JavaPropsFactory();
        JsonParser parser = factory.createParser((Reader)new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
        YAMLFactory yamlFactory = new YAMLFactory();
        YAMLGenerator generator = yamlFactory.createGenerator((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(targetPath), StandardCharsets.UTF_8));
        JsonToken token = parser.nextToken();
        while (token != null) {
            if (JsonToken.START_OBJECT.equals((Object)token)) {
                generator.writeStartObject();
            } else if (JsonToken.FIELD_NAME.equals((Object)token)) {
                generator.writeFieldName(parser.getCurrentName());
            } else if (JsonToken.VALUE_STRING.equals((Object)token)) {
                generator.writeString(parser.getText());
            } else if (JsonToken.END_OBJECT.equals((Object)token)) {
                generator.writeEndObject();
            }
            token = parser.nextToken();
        }
    }
}

