/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.core.support;

import cn.meteor.common.core.util.Func;
import cn.meteor.common.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrSplitter {
    public static List<String> splitPath(String str) {
        return StrSplitter.splitPath(str, 0);
    }

    public static String[] splitPathToArray(String str) {
        return StrSplitter.toArray(StrSplitter.splitPath(str));
    }

    public static List<String> splitPath(String str, int limit) {
        return StrSplitter.split(str, "/", limit, true, true);
    }

    public static String[] splitPathToArray(String str, int limit) {
        return StrSplitter.toArray(StrSplitter.splitPath(str, limit));
    }

    public static List<String> splitTrim(String str, char separator, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, 0, true, ignoreEmpty);
    }

    public static List<String> split(String str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> splitTrim(String str, char separator, int limit, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, limit, true, ignoreEmpty, false);
    }

    public static List<String> split(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitIgnoreCase(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> split(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StringUtil.isBlank(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StrSplitter.addToList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        ArrayList<String> list = new ArrayList<String>(limit > 0 ? limit : 16);
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!Func.equals(Character.valueOf(separator), Character.valueOf(str.charAt(i)))) continue;
            StrSplitter.addToList(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StrSplitter.addToList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] splitToArray(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    public static List<String> split(String str, String separator, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, -1, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitTrim(String str, String separator, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, true, ignoreEmpty);
    }

    public static List<String> split(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitTrim(String str, String separator, int limit, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, limit, true, ignoreEmpty);
    }

    public static List<String> splitIgnoreCase(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitTrimIgnoreCase(String str, String separator, int limit, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, limit, true, ignoreEmpty, true);
    }

    public static List<String> split(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StringUtil.isBlank(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StrSplitter.addToList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        if (StringUtil.isBlank(separator)) {
            return StrSplitter.split(str, limit);
        }
        if (separator.length() == 1) {
            return StrSplitter.split(str, separator.charAt(0), limit, isTrim, ignoreEmpty, ignoreCase);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int separatorLen = separator.length();
        int start = 0;
        int i = 0;
        while (i < len && (i = StringUtil.indexOf((CharSequence)str, separator, start, ignoreCase)) > -1) {
            StrSplitter.addToList(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + separatorLen;
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return StrSplitter.addToList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] splitToArray(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    public static List<String> split(String str, int limit) {
        if (StringUtil.isBlank(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StrSplitter.addToList(new ArrayList<String>(1), str, true, true);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!Func.isEmpty(Character.valueOf(str.charAt(i)))) continue;
            StrSplitter.addToList(list, str.substring(start, i), true, true);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StrSplitter.addToList(list, str.substring(start, len), true, true);
    }

    public static String[] splitToArray(String str, int limit) {
        return StrSplitter.toArray(StrSplitter.split(str, limit));
    }

    public static List<String> split(String str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (StringUtil.isBlank(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StrSplitter.addToList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        if (null == separatorPattern) {
            return StrSplitter.split(str, limit);
        }
        Matcher matcher = separatorPattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        while (matcher.find()) {
            StrSplitter.addToList(list, str.substring(start, matcher.start()), isTrim, ignoreEmpty);
            start = matcher.end();
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return StrSplitter.addToList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] splitToArray(String str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str, separatorPattern, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitByLength(String str, int len) {
        int partCount = str.length() / len;
        int lastPartCount = str.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? str.substring(i * len, i * len + lastPartCount) : str.substring(i * len, i * len + len);
        }
        return strs;
    }

    private static List<String> addToList(List<String> list, String part, boolean isTrim, boolean ignoreEmpty) {
        if (isTrim) {
            part = part.trim();
        }
        if (!ignoreEmpty || !part.isEmpty()) {
            list.add(part);
        }
        return list;
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }
}

