package cn.meteor.common.web.util;

import cn.meteor.common.launch.constants.TokenConstants;
import cn.meteor.common.launch.spring.SpringUtil;
import cn.meteor.common.model.R;
import cn.meteor.common.model.UserInfo;
import cn.meteor.common.web.feign.ILoginClient;

import javax.servlet.http.HttpServletRequest;

/**
 * Token 工具类
 *
 * @author ths
 * @since 1.0.0
 */
public class TokenUtil {

	public static UserInfo getUserInfo() {
		HttpServletRequest request = WebUtil.getRequest();
		if (request == null) {
			return null;
		}
		ILoginClient loginClient = SpringUtil.getBean(ILoginClient.class);
		String token = request.getHeader(TokenConstants.HEADER);
		if (token == null) {
			return null;
		}
		R<UserInfo> userInfo = loginClient.userInfoByToken(token);
		if (userInfo.isFailure()) {
			return null;
		}
		return userInfo.getData();
	}
}
