package cn.meteor.common.web.configure;

import cn.meteor.common.launch.constants.TokenConstants;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * @author ths
 * @since 1.0.0
 */
public class FeignConfigure {


	/**
	 * 解决fein远程调用丢失请求头
	 *
	 * @return requestInterceptor 拦截器
	 */
	@Bean
	public RequestInterceptor requestInterceptor() {
		return template -> {
			// 1、RequestContextHolder 拿到当前的请求
			ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
			if (attributes != null) {
				// 原始请求 页面发起的老请求
				HttpServletRequest request = attributes.getRequest();
				// 获取原始请求的头数据 token
				String token = request.getHeader(TokenConstants.HEADER);

				// 给feign生成的心请求设置请求头cookie
				template.header(TokenConstants.HEADER, token);
			}
		};
	}
}
