package cn.meteor.common.web.feign;

import cn.meteor.common.launch.constants.AppConstants;
import cn.meteor.common.model.R;
import cn.meteor.common.model.UserInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 登录相关
 *
 * @author ths
 * @since 1.0.0
 */
@FeignClient(
	name = AppConstants.APP_SYSTEM_NAME,
	contextId = "loginClient",
	path = "/user",
	fallback = ILoginClientFallback.class
)
public interface ILoginClient {

	/**
	 * 根据token获取用户信息
	 *
	 * @param token token
	 * @return 用户信息
	 */
	@GetMapping(value = "userInfoByToken", produces = MediaType.APPLICATION_JSON_VALUE)
	R<UserInfo> userInfoByToken(@RequestParam("token") String token);

}
