/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.test;

import cn.meteor.common.exception.ServiceException;
import cn.meteor.common.launch.MeteorApplication;
import cn.meteor.common.launch.service.LauncherService;
import cn.meteor.common.test.MeteorBootTest;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class MeteorSpringExtension
extends SpringExtension {
    private static final Logger log = LoggerFactory.getLogger(MeteorSpringExtension.class);

    public void beforeAll(@NonNull ExtensionContext context) throws Exception {
        super.beforeAll(context);
        this.setUpTestClass(context);
    }

    private void setUpTestClass(ExtensionContext context) {
        Class clazz = context.getRequiredTestClass();
        MeteorBootTest bladeBootTest = (MeteorBootTest)AnnotationUtils.getAnnotation((AnnotatedElement)clazz, MeteorBootTest.class);
        if (bladeBootTest == null) {
            throw new ServiceException(String.format("%s must be @MeteorBootTest .", clazz));
        }
        String appName = bladeBootTest.appName();
        String profile = bladeBootTest.profile();
        MeteorApplication.initProperty((String)appName, (String)profile);
        if (bladeBootTest.enableLoader()) {
            ArrayList launcherList = new ArrayList();
            SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{clazz});
            ServiceLoader.load(LauncherService.class).forEach(launcherList::add);
            launcherList.stream().sorted(Comparator.comparing(LauncherService::getOrder)).collect(Collectors.toList()).forEach(launcherService -> launcherService.launcher(builder, appName, profile));
        }
        log.info("---[junit.test]:[{}]---\u542f\u52a8\u4e2d\uff0c\u8bfb\u53d6\u5230\u7684\u73af\u5883\u53d8\u91cf:[{}]---", (Object)appName, (Object)profile);
    }
}

