package cn.meteor.common.test;// Copyright (C), Created on 2021-04-03

import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

/**
 * 测试启动类
 *
 * @author ths
 * @since 1.0.0
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
@SpringBootTest
@ExtendWith(MeteorSpringExtension.class)
public @interface MeteorBootTest {
	/**
	 * 服务名：appName
	 *
	 * @return appName
	 */
	@AliasFor("appName")
	String value() default "meteor-test";

	/**
	 * 服务名：appName
	 *
	 * @return appName
	 */
	@AliasFor("value")
	String appName() default "meteor-test";

	/**
	 * profile
	 *
	 * @return profile
	 */
	String profile() default "dev";

	/**
	 * 启用 ServiceLoader 加载 launcherService
	 *
	 * @return 是否启用
	 */
	boolean enableLoader() default false;
}
