package cn.meteor.common.test;// Copyright (C), Created on 2021-04-03

import cn.meteor.common.exception.ServiceException;
import cn.meteor.common.launch.MeteorApplication;
import cn.meteor.common.launch.service.LauncherService;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

/**
 * 设置启动参数
 *
 * @author ths
 * @since 1.0.0
 */
@Slf4j
public class MeteorSpringExtension extends SpringExtension {

	@Override
	public void beforeAll(@NonNull ExtensionContext context) throws Exception {
		super.beforeAll(context);
		setUpTestClass(context);
	}

	private void setUpTestClass(ExtensionContext context) {
		Class<?> clazz = context.getRequiredTestClass();
		MeteorBootTest bladeBootTest = AnnotationUtils.getAnnotation(clazz, MeteorBootTest.class);
		if (bladeBootTest == null) {
			throw new ServiceException(String.format("%s must be @MeteorBootTest .", clazz));
		}
		String appName = bladeBootTest.appName();
		String profile = bladeBootTest.profile();
		MeteorApplication.initProperty(appName, profile);
		// 加载自定义组件
		if (bladeBootTest.enableLoader()) {
			List<LauncherService> launcherList = new ArrayList<>();
			SpringApplicationBuilder builder = new SpringApplicationBuilder(clazz);
			ServiceLoader.load(LauncherService.class).forEach(launcherList::add);
			launcherList.stream().sorted(Comparator.comparing(LauncherService::getOrder)).collect(Collectors.toList())
				.forEach(launcherService -> launcherService.launcher(builder, appName, profile));
		}
		log.info("---[junit.test]:[{}]---启动中，读取到的环境变量:[{}]---", appName, profile);
	}

}
