/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.redis.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.meteor.common.redis.dao.AbstractRedisDao;
import cn.meteor.common.redis.dao.IRedisDao;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.util.CollectionUtils;

public class RedisDaoImpl<K, V>
extends AbstractRedisDao<K, V>
implements IRedisDao<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RedisDaoImpl.class);

    @Override
    public int getSize() {
        Long size = (Long)this.redisTemplate.execute(RedisServerCommands::dbSize);
        return size == null ? 0 : size.intValue();
    }

    @Override
    public DataType type(K key) {
        return this.redisTemplate.type(key);
    }

    @Override
    public boolean existsKey(K key) {
        Boolean existsKey = this.redisTemplate.hasKey(key);
        return existsKey == null ? Boolean.FALSE : existsKey;
    }

    @Override
    public void renameKey(K oldKey, K newKey) {
        if (this.existsKey(oldKey)) {
            this.redisTemplate.rename(oldKey, newKey);
        }
    }

    @Override
    public Set<K> keys(K pattern) {
        return this.redisTemplate.keys(pattern);
    }

    @Override
    public int count(K key) {
        Set objects = this.redisTemplate.keys(key);
        return CollectionUtils.isEmpty((Collection)objects) ? 0 : objects.size();
    }

    @Override
    public boolean delete(K key) {
        Boolean result = this.redisTemplate.delete(key);
        return result == null ? Boolean.FALSE : result;
    }

    @Override
    public void delete(K[] keys) {
        if (keys == null || keys.length < 1) {
            return;
        }
        for (K key : keys) {
            boolean result = this.delete(key);
            if (result || !log.isErrorEnabled()) continue;
            log.error("redis\u6279\u91cf\u5220\u9664\u5931\u8d25\uff0ckey = {}", key);
        }
    }

    @Override
    public long deletePattern(K pattern) {
        Set objects = this.redisTemplate.keys(pattern);
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return 0L;
        }
        return this.delete(objects);
    }

    @Override
    public long delete(Set<K> keys) {
        Long deleteNum = this.redisTemplate.delete(keys);
        return deleteNum == null ? 0L : deleteNum;
    }

    @Override
    public boolean set(K key, V value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set(key, value);
            result = true;
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u83b7\u53d6\u5230redis\u503ckey:{}", key, (Object)e);
        }
        return result;
    }

    @Override
    public boolean incr(K key, Long value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.increment(key, value.longValue());
            result = true;
        }
        catch (Exception e) {
            log.error("\u5c06key\u4e2d\u50a8\u5b58\u7684\u6570\u5b57\u52a0\u4e0a\u6307\u5b9a\u7684\u589e\u91cf\u503c(\u64cd\u4f5c\u5b57\u7b26\u4e32)key:{}", key, (Object)e);
        }
        return result;
    }

    @Override
    public boolean set(K key, V value, Long expireTime, TimeUnit unit) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set(key, value);
            this.redisTemplate.expire(key, expireTime.longValue(), unit);
            result = true;
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u5c06\u5199\u5165\u7f13\u5b58\u8bbe\u7f6e\u65f6\u6548\u65f6\u95f4:key:{}", key);
        }
        return result;
    }

    @Override
    public boolean set(K key, V value, Long expireTime) {
        return this.set(key, value, expireTime, TimeUnit.SECONDS);
    }

    @Override
    public boolean updateExpireTime(K key, Long expireTime) {
        boolean result = false;
        try {
            this.redisTemplate.expire(key, expireTime.longValue(), TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u66f4\u65b0\u5199\u5165\u7f13\u5b58\u8bbe\u7f6e\u65f6\u6548\u65f6\u95f4:key:{}", key);
        }
        return result;
    }

    @Override
    public <T> T get(K key, Class<T> clazz) {
        Object value = this.redisTemplate.opsForValue().get(key);
        if (ObjectUtil.isNull((Object)value)) {
            return null;
        }
        return (T)value;
    }

    @Override
    public void hSet(K key, K hashKey, V value) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.put(key, hashKey, value);
    }

    @Override
    public void hIncr(K key, K hashKey, Long value) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.increment(key, hashKey, value.longValue());
    }

    @Override
    public void hSetAll(K key, Map<K, V> map) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.putAll(key, map);
    }

    @Override
    public Map<K, V> hGet(K key) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.entries(key);
    }

    @Override
    public <T> T hGet(K key, K hashKey, Class<T> clazz) {
        HashOperations hash = this.redisTemplate.opsForHash();
        Object value = hash.get(key, hashKey);
        if (ObjectUtil.isNull((Object)value)) {
            return null;
        }
        return (T)value;
    }

    @Override
    public long hDel(K key, K ... hashKey) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.delete(key, new Object[]{hashKey});
    }

    @Override
    public long hSize(K key) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.size(key);
    }

    @Override
    public List<V> hValues(K key) {
        return this.redisTemplate.opsForHash().values(key);
    }

    @Override
    public long lSize(K key) {
        ListOperations list = this.redisTemplate.opsForList();
        Long size = list.size(key);
        return size == null ? 0L : size;
    }

    @Override
    public V lIndexFirst(K key) {
        ListOperations list = this.redisTemplate.opsForList();
        return (V)list.index(key, 0L);
    }

    @Override
    public V lIndex(K k, long index) {
        ListOperations list = this.redisTemplate.opsForList();
        return (V)list.index(k, index);
    }

    @Override
    public boolean lLeftPush(K key, V value) {
        ListOperations list = this.redisTemplate.opsForList();
        Long result = list.leftPush(key, value);
        return result == null ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public boolean lLeftPush(K key, V value, boolean bool) {
        Long result;
        ListOperations list = this.redisTemplate.opsForList();
        if (bool) {
            Long size = list.size(key);
            list.remove(key, size == null ? 0L : size, value);
        }
        return (result = list.leftPush(key, value)) == null ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public long lLeftPushAll(K key, List<V> lst) {
        ListOperations list = this.redisTemplate.opsForList();
        Long num = list.leftPushAll(key, lst);
        return num == null ? 0L : num;
    }

    @Override
    public boolean lRightPush(K key, V value) {
        ListOperations list = this.redisTemplate.opsForList();
        Long result = list.rightPush(key, value);
        return result == null ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public boolean lRightPush(K key, V value, boolean bool) {
        Long result;
        ListOperations list = this.redisTemplate.opsForList();
        if (bool) {
            Long size = list.size(key);
            list.remove(key, size == null ? 0L : size, value);
        }
        return (result = list.rightPush(key, value)) == null ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public long lRightPushAll(K key, List<V> lst) {
        ListOperations list = this.redisTemplate.opsForList();
        Long num = list.rightPushAll(key, lst);
        return num == null ? 0L : num;
    }

    @Override
    public V lLeftPop(K key) {
        return (V)this.redisTemplate.opsForList().leftPop(key);
    }

    @Override
    public V lRightPop(K key) {
        return (V)this.redisTemplate.opsForList().rightPop(key);
    }

    @Override
    public long lRemove(K key, long count) {
        return this.lRemove(key, count, null);
    }

    @Override
    public long lRemove(K key, long count, V value) {
        if (value == null) {
            return 0L;
        }
        ListOperations list = this.redisTemplate.opsForList();
        Long num = list.remove(key, count, value);
        return num == null ? 0L : num;
    }

    @Override
    public long lRemove(K key, V value) {
        ListOperations list;
        Long size = (list = this.redisTemplate.opsForList()).size(key);
        Long num = list.remove(key, size == null ? 0L : size, value);
        return num == null ? 0L : num;
    }

    @Override
    public List<V> lRange(K key) {
        ListOperations list;
        Long size = (list = this.redisTemplate.opsForList()).size(key);
        return list.range(key, 0L, size == null ? 0L : size);
    }

    @Override
    public List<V> lRange(K k, long start, long end) {
        return this.redisTemplate.opsForList().range(k, start, end);
    }

    @Override
    public long sAdd(K key, V ... value) {
        SetOperations set = this.redisTemplate.opsForSet();
        Long num = set.add(key, (Object[])value);
        return num == null ? 0L : num;
    }

    @Override
    public V sRandomMember(K key) {
        SetOperations set = this.redisTemplate.opsForSet();
        return (V)set.randomMember(key);
    }

    @Override
    public List<V> sRandomMembers(K key, long count) {
        SetOperations set = this.redisTemplate.opsForSet();
        return set.randomMembers(key, count);
    }

    @Override
    public Set<V> sDistinctRandomMembers(K key, long count) {
        SetOperations set = this.redisTemplate.opsForSet();
        return set.distinctRandomMembers(key, count);
    }

    @Override
    public V sPop(K key) {
        SetOperations set = this.redisTemplate.opsForSet();
        return (V)set.pop(key);
    }

    @Override
    public long sRemove(K key, V ... values) {
        SetOperations set = this.redisTemplate.opsForSet();
        Long num = set.remove(key, (Object[])values);
        return num == null ? 0L : num;
    }

    @Override
    public Set<V> sMembers(K key) {
        SetOperations set = this.redisTemplate.opsForSet();
        return set.members(key);
    }

    @Override
    public boolean sIsMember(K key, V value) {
        SetOperations set = this.redisTemplate.opsForSet();
        Boolean exists = set.isMember(key, value);
        return exists == null ? Boolean.FALSE : exists;
    }

    @Override
    public long sSize(K key) {
        SetOperations set = this.redisTemplate.opsForSet();
        Long size = set.size(key);
        return size == null ? 0L : size;
    }

    @Override
    public Set<V> sDifference(K key, K otherKey) {
        SetOperations set = this.redisTemplate.opsForSet();
        return set.difference(key, otherKey);
    }

    @Override
    public boolean zAdd(K key, V value, double score) {
        Boolean add = this.redisTemplate.opsForZSet().add(key, value, score);
        return add == null ? Boolean.FALSE : add;
    }

    @Override
    public long zAdd(K key, Set<ZSetOperations.TypedTuple<V>> tuples) {
        Long num = this.redisTemplate.opsForZSet().add(key, tuples);
        return num == null ? 0L : num;
    }

    @Override
    public long zRemove(K key, V ... values) {
        Long num = this.redisTemplate.opsForZSet().remove(key, (Object[])values);
        return num == null ? 0L : num;
    }

    @Override
    public Set<V> zRangeByScore(K key, double lowScore, double highScore) {
        return this.redisTemplate.opsForZSet().rangeByScore(key, lowScore, highScore);
    }
}

