/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.redis.aspectj;

import cn.hutool.core.util.ArrayUtil;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public interface BaseCacheAspect {
    default public String getKey(JoinPoint point, String key) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        StringBuilder sbr = new StringBuilder();
        String[] paras = signature.getParameterNames();
        this.getElKey(point, key, sbr, paras);
        return sbr.toString();
    }

    default public void getElKey(JoinPoint point, String key, StringBuilder sbr, String[] paras) {
        if (ArrayUtil.isEmpty((Object[])paras)) {
            sbr.append(key);
            return;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        int length = paras.length;
        for (int i = 0; i < length; ++i) {
            Object[] params = point.getArgs();
            context.setVariable(paras[i], params[i]);
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        String elKey = Objects.requireNonNull(parser.parseExpression(key).getValue((EvaluationContext)context)).toString();
        sbr.append(elKey);
    }
}

