/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.redis.configure;

import cn.meteor.common.redis.lock.DistributedLocker;
import cn.meteor.common.redis.lock.RedissLockUtil;
import cn.meteor.common.redis.lock.RedissonDistributedLocker;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={RedisProperties.class})
@ConditionalOnClass(value={RedissonClient.class})
public class RedissonConfigure {
    @Autowired
    private RedisProperties redisProperties;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        if (this.redisProperties.getCluster() != null) {
            String[] clusterNodes = new String[this.redisProperties.getCluster().getNodes().size()];
            for (int i = 0; i < this.redisProperties.getCluster().getNodes().size(); ++i) {
                clusterNodes[i] = "redis://" + (String)this.redisProperties.getCluster().getNodes().get(i);
            }
            config.useClusterServers().setScanInterval(2000).addNodeAddress(clusterNodes).setPassword(this.redisProperties.getPassword());
        } else if (this.redisProperties.getSentinel() != null) {
            String[] sentinelNodes = new String[this.redisProperties.getSentinel().getNodes().size()];
            for (int i = 0; i < this.redisProperties.getSentinel().getNodes().size(); ++i) {
                sentinelNodes[i] = "redis://" + (String)this.redisProperties.getSentinel().getNodes().get(i);
            }
            ((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(this.redisProperties.getSentinel().getMaster()).setDatabase(this.redisProperties.getDatabase()).addSentinelAddress(sentinelNodes).setPassword(this.redisProperties.getPassword())).setTimeout((int)this.redisProperties.getTimeout().toMillis())).setMasterConnectionPoolSize(this.redisProperties.getLettuce().getPool().getMaxActive())).setSlaveConnectionPoolSize(this.redisProperties.getLettuce().getPool().getMaxActive())).setCheckSentinelsList(false);
        } else {
            ((SingleServerConfig)config.useSingleServer().setAddress("redis://" + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setDatabase(this.redisProperties.getDatabase()).setTimeout((int)this.redisProperties.getTimeout().toMillis())).setConnectionPoolSize(this.redisProperties.getLettuce().getPool().getMaxActive()).setConnectionMinimumIdleSize(this.redisProperties.getLettuce().getPool().getMinIdle()).setPassword(this.redisProperties.getPassword());
        }
        return Redisson.create((Config)config);
    }

    @Bean
    @ConditionalOnClass(value={RedissonClient.class})
    DistributedLocker distributedLocker(RedissonClient redissonClient) {
        RedissonDistributedLocker locker = new RedissonDistributedLocker();
        locker.setRedissonClient(redissonClient);
        RedissLockUtil.setLocker(locker);
        return locker;
    }
}

