/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.redis.aspectj;

import cn.meteor.common.enums.ResultType;
import cn.meteor.common.interfaces.IResultType;
import cn.meteor.common.model.R;
import cn.meteor.common.redis.annotation.RedisLock;
import cn.meteor.common.redis.aspectj.BaseCacheAspect;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@Aspect
@ConditionalOnClass(value={RedissonClient.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedisLockAspect
extends BaseCacheAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisLockAspect.class);
    @Autowired
    private RedissonClient redissonClient;

    @Pointcut(value="@annotation(redisLock)")
    public void pointCut(RedisLock redisLock) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="pointCut(redisLock)")
    public Object interceptor(ProceedingJoinPoint point, RedisLock redisLock) {
        String key = redisLock.preKey() + ":" + this.getKey((JoinPoint)point, redisLock.key());
        RLock lock = this.redissonClient.getLock(key);
        boolean isLock = lock.tryLock(redisLock.timeBlock(), redisLock.timeOut(), redisLock.timeUnit());
        if (!isLock) {
            log.error("\u6ca1\u6709\u83b7\u53d6\u5230\u9501\uff0ckey = {}", (Object)key);
            return R.failure((IResultType)ResultType.CRUD_LOCK_OPERATE);
        }
        try {
            log.info("\u83b7\u53d6\u5230\u9501\uff0ckey = {}", (Object)key);
            Object object = point.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    private RedisLock getRedisLock(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(RedisLock.class);
        }
        return null;
    }
}

