package cn.meteor.common.redis.lock;

import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

import java.util.concurrent.TimeUnit;

/**
 * Lock的接口定义类
 *
 * @author ths
 */
public interface DistributedLocker {

	/**
	 * 设置 redissonClient
	 *
	 * @param redissonClient redissonClient
	 */
	void setRedissonClient(RedissonClient redissonClient);

	/**
	 * 加锁
	 *
	 * @param lockKey key
	 * @return 锁
	 */
	RLock lock(String lockKey);

	/**
	 * 带超时的锁
	 *
	 * @param lockKey key
	 * @param unit    时间单位
	 * @param timeout 超时时间
	 * @return 锁
	 */
	RLock lock(String lockKey, TimeUnit unit, int timeout);

	/**
	 * 尝试获取锁
	 *
	 * @param lockKey   key
	 * @param unit      时间单位
	 * @param waitTime  最多等待时间
	 * @param leaseTime 上锁后自动释放锁时间
	 * @return 锁
	 */
	boolean tryLock(String lockKey, TimeUnit unit, int waitTime, int leaseTime);

	/**
	 * 释放锁
	 *
	 * @param lockKey key
	 */
	void unlock(String lockKey);

	/**
	 * 释放锁
	 *
	 * @param lock 锁
	 */
	void unlock(RLock lock);
}
