package cn.meteor.common.redis.aspectj;

import cn.hutool.core.util.ArrayUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.util.Objects;

/**
 * cache 缓存切面
 *
 * @author ths
 */
public abstract class BaseCacheAspect {

	/**
	 * 获取redis锁key
	 *
	 * @param point 切入点
	 * @param key   键
	 * @return 锁key
	 */
	public String getKey(JoinPoint point, String key) {
		MethodSignature signature = (MethodSignature) point.getSignature();
		StringBuilder sbr = new StringBuilder();
		String[] paras = signature.getParameterNames();
		getElKey(point, key, sbr, paras);
		return sbr.toString();
	}

	/**
	 * 通过el表达式获取到key
	 *
	 * @param point 切入点
	 * @param key   键
	 * @param sbr   返回结果
	 * @param paras el 表达式
	 */
	public void getElKey(JoinPoint point, String key, StringBuilder sbr, String[] paras) {
		if (ArrayUtil.isEmpty(paras)) {
			sbr.append(key);
			return;
		}
		EvaluationContext context = new StandardEvaluationContext();
		for (int i = 0, length = paras.length; i < length; i++) {
			Object[] params = point.getArgs();
			context.setVariable(paras[i], params[i]);
		}
		// 处理EL 表达式
		SpelExpressionParser parser = new SpelExpressionParser();
		String elKey = Objects.requireNonNull(parser.parseExpression(key).getValue(context)).toString();
		sbr.append(elKey);
	}
}
