/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.jasypt;

import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.jasypt.iv.RandomIvGenerator;
import org.jasypt.salt.RandomSaltGenerator;

public class JasyptUtil {
    public static String stringEncryptor(String secretKey, String message, boolean isEncrypt) {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        encryptor.setConfig((PBEConfig)JasyptUtil.getSimpleStringPbeConfig(secretKey));
        return isEncrypt ? encryptor.encrypt(message) : encryptor.decrypt(message);
    }

    private static SimpleStringPBEConfig getSimpleStringPbeConfig(String secretKey) {
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(secretKey);
        config.setPoolSize("1");
        config.setAlgorithm("PBEWITHHMACSHA512ANDAES_256");
        config.setKeyObtentionIterations("1000");
        config.setProviderName("SunJCE");
        config.setSaltGeneratorClassName(RandomSaltGenerator.class.getName());
        config.setIvGeneratorClassName(RandomIvGenerator.class.getName());
        config.setStringOutputType("base64");
        return config;
    }
}

