package cn.meteor.common.model;// Copyright (C), Created on 2021-04-03

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 分页响应
 *
 * @author ths
 * @since 1.0.0
 */
@Schema(title = "分页响应模型")
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PageModel<T> extends R<List<T>> {

	@Schema(name = "当前页码", required = true)
	private int current;
	@Schema(name = "每页显示条数", required = true)
	private int pageSize;
	@Schema(name = "总页数", required = true)
	private int pages;
	@Schema(name = "总条数", required = true)
	private int total;

}
