package cn.meteor.common.util;// Copyright (C), Created on 2021-08-12

import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

/**
 * @author ths
 * @since 1.0.0
 */
public class CryptUtil {
	private static final BCryptPasswordEncoder ENCODER = new BCryptPasswordEncoder();

	/**
	 * 加密字符串并返回
	 *
	 * @param rawData 原数据
	 * @return 加密后数据
	 */
	public static String getCrypt(String rawData) {
		return ENCODER.encode(rawData);
	}


	/**
	 * 判断元数据是否加密后数据匹配
	 *
	 * @param rawData     原数据
	 * @param encodedData 加密数据
	 * @return 是否相同
	 */
	public static boolean matched(String rawData, String encodedData) {
		return ENCODER.matches(rawData, encodedData);
	}
}
