package cn.meteor.common.util;

import lombok.extern.slf4j.Slf4j;

import java.io.File;

/**
 * maven 清理
 *
 * @author ths
 */
@Slf4j
public class MavenUtil {

	private static int emptyDirectoryNum;
	private static int invalidFileNum;
	private static int failedNum;

	/**
	 * 递归删除文件夹
	 *
	 * @param path 仓库路径
	 */
	public static void clear(String path) {
		clearRepository(path);
		log.debug("【执行结果】\t-->> 删除文件 {} 个 , 删除目录 {} 个 , 删除失败 {} 个.", invalidFileNum, emptyDirectoryNum, failedNum);
	}

	/**
	 * 递归删除文件夹
	 *
	 * @param path 仓库路径
	 */
	private static void clearRepository(String path) {
		clearRepository(new File(path));
	}

	/**
	 * 递归删除文件夹
	 *
	 * @param file 仓库目录/文件
	 */
	private static void clearRepository(File file) {
		if (file == null) {
			return;
		}
		if (file.isDirectory()) {
			File[] items = file.listFiles();
			if (items == null) {
				return;
			}
			if (items.length == 0) {
				deleteLogger(file);
				return;
			}
			for (File item : items) {
				clearRepository(item);
			}
		}
		// 删除所有.lastUpdated结尾的文件
		// 删除所有_remote.repositories
		if (file.getName().contains("lastUpdated")) {
			deleteLogger(file);
		}
	}

	/**
	 * 统计删除日志
	 *
	 * @param file 要删除的文件
	 */
	private static void deleteLogger(File file) {
		if (file.delete()) {
			if (file.isDirectory()) {
				emptyDirectoryNum++;
			} else {
				invalidFileNum++;
			}
			log.debug("【删除{}】\t-->> {}", file.isDirectory() ? "目录" : "文件", file.getAbsolutePath());
		} else {
			failedNum++;
			log.error("【删除失败】\t-->> {}", file.getAbsolutePath());
		}
	}

	public static void main(String[] args) {
		MavenUtil.clear("/Users/ths/Documents/repo");
	}
}

