package cn.meteor.common.service;

import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.meteor.common.properties.EmailProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * 邮件通知统计类
 *
 * @author ths
 * @since 1.0.0
 */
@Slf4j
@EnableConfigurationProperties({EmailProperties.class})
@ConditionalOnProperty(prefix = "meteor.email", name = "enabled", havingValue = "true")
public class EmailService {

	/**
	 * 发送邮件给多人(发件人为腾讯邮箱)
	 *
	 * @param subject 标题
	 * @param content 正文
	 * @return 成功/失败
	 */
	public static boolean sendTencentMail(String subject, String content) {
		return sendTencentMail(subject, content, false);
	}

	/**
	 * 发送邮件给多人(发件人为腾讯邮箱)
	 *
	 * @param subject 标题
	 * @param content 正文
	 * @param isHtml  是否为HTML格式
	 * @return 成功/失败
	 */
	public static boolean sendTencentMail(String subject, String content, boolean isHtml) {
		try {
			EmailProperties props = SpringUtil.getBean(EmailProperties.class);
			MailAccount account = new MailAccount();
			account.setHost("smtp.exmail.qq.com");
			account.setSocketFactoryPort(465);
			account.setAuth(true);
			account.setFrom(props.getFrom());
			account.setPass(props.getPassword());
			MailUtil.send(account, props.getTos(), subject, content, isHtml);
		} catch (Exception e) {
			log.error("发送邮件时异常", e);
			return false;
		}
		return true;
	}
}
