package cn.meteor.common.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 自动配置 thread pol
 *
 * @author ths
 */
@Data
@ConfigurationProperties("thread.pool")
public class ThreadPoolProperties {

	/** 是否启用配置bean */
	private Boolean enabled = false;
	/** 核心线程数 */
	private int corePoolSize;
	/** 最大线程数 */
	private int maximumPoolSize;
	/** 保持活着的时间 */
	private long keepAliveTime;

}
