package cn.meteor.common.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * @author ths
 * @since 1.0.0
 */
@Data
@ConfigurationProperties(prefix = "meteor.email")
public class EmailProperties {

	/** 发件人邮箱 */
	private String from;
	/** 发件人密码 */
	private String password;
	/** 收件人列表 */
	private List<String> tos;
	/** 是否启用 */
	private boolean enabled;
}
