package cn.meteor.common.exception;// Copyright (C), Created on 2021-04-03

import cn.meteor.common.enums.ResultType;
import lombok.Getter;
import org.slf4j.Logger;

import java.util.function.Supplier;

/**
 * 服务通用异常
 *
 * @author ths
 * @since 1.0.0
 */
public class ServiceException extends RuntimeException implements Supplier<ServiceException> {

	/** 错误枚举 */
	@Getter
	private ResultType resultEnum;
	/** 错误编码 */
	@Getter
	private int code;

	/**
	 * 仅包含message, 没有cause, 也不记录栈异常, 性能最高
	 *
	 * @param resultEnum 返回的code统一管理
	 */
	public ServiceException(ResultType resultEnum) {
		this(resultEnum.getMessage(), false);
		this.resultEnum = resultEnum;
		this.code = resultEnum.getCode();
	}

	/**
	 * 仅包含message, 没有cause, 也不记录栈异常, 性能最高
	 *
	 * @param code    错误编码
	 * @param message 错误信息
	 */
	public ServiceException(int code, String message) {
		this(message, false);
		this.code = code;
	}

	/**
	 * 仅包含message, 没有cause, 也不记录栈异常, 性能最高
	 *
	 * @param message 异常的描述信息
	 */
	public ServiceException(String message) {
		this(message, false);
	}

	/**
	 * 仅包含message, 没有cause, 也不记录栈异常, 性能最高
	 *
	 * @param log     日志
	 * @param message 异常的描述信息
	 * @param e 异常类
	 * @return ServiceException
	 */
	public static ServiceException log(Logger log, String message, Exception e) {
		log.error(message, e);
		return new ServiceException(message);
	}

	/**
	 * 包含message, 可指定是否记录异常
	 *
	 * @param message          异常的描述信息
	 * @param recordStackTrace 否生成栈追踪信息
	 */
	private ServiceException(String message, boolean recordStackTrace) {
		super(message, null, false, recordStackTrace);
	}

	/**
	 * 包含message和cause, 会记录栈异常
	 *
	 * @param message 异常的描述信息
	 * @param cause   异常
	 */
	public ServiceException(String message, Throwable cause) {
		super(message, cause, false, true);
	}

	@Override
	public ServiceException get() {
		return this;
	}
}
