package cn.meteor.common.data;// Copyright (C), Created on 2021-04-03

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

/**
 * 分页请求对象
 *
 * @author ths
 * @since 1.0.0
 */
@Schema(title = "分页请求对象")
@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class PageData extends BaseData {

	@Schema(name = "当前页码，默认 1", example = "1")
	@Min(value = 1, message = "页码数最小值为1", groups = {Page.class})
	private int current;
	@Schema(name = "每页显示条数，默认 10", example = "10")
	@Min(value = 1, message = "每页数量最小值为1", groups = {Page.class})
	@Max(value = 1000, message = "每页数量最大值为1000", groups = {Page.class})
	private int pageSize;
	@Schema(name = "排序字段")
	private String sortField;
	@Schema(name = "排序：默认 0，0 asc, 1 desc")
	private int sortBy;
}
