package cn.meteor.common.configure;

import cn.meteor.common.properties.ThreadPoolProperties;
import cn.meteor.common.thread.ThreadPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * @author ths
 */
@EnableConfigurationProperties(ThreadPoolProperties.class)
@ConditionalOnProperty(name = "thread.pool.enabled", havingValue = "true")
public class ThreadPoolAutoConfigure {

	@Autowired
	private ThreadPoolProperties threadPoolProperties;

	@Bean
	@ConditionalOnMissingBean
	public ThreadPool threadPool() {
		ThreadPool.init(threadPoolProperties.getCorePoolSize(),
			threadPoolProperties.getMaximumPoolSize(),
			threadPoolProperties.getKeepAliveTime());
		return new ThreadPool();
	}

}
