package cn.meteor.common.autoconfiguration;// Copyright (C), Created on 2021-04-01

import org.springframework.beans.factory.annotation.Value;

/**
 * Springboot 启动配置加载类
 *
 * @author ths
 * @since 1.0.0
 */
public class ConfigurationUtil {

	/** 服务名称 */
	public static String appName;
	/** 服务环境 */
	public static String profile;
	/** 服务端口 */
	public static String port;

	@Value("${spring.application.name:unknown}")
	public void setAppName(String appName) {
		setStaticAppName(appName);
	}
	@Value("${spring.application.name:unknown}")
	public synchronized static void setStaticAppName(String appName) {
		ConfigurationUtil.appName = appName;
	}

	@Value("${spring.profiles.active:unknown}")
	public void setProfile(String profile) {
		ConfigurationUtil.profile = profile;
	}

	@Value("${server.port:0000}")
	public void setPort(String port) {
		ConfigurationUtil.port = port;
	}
}
