package cn.meteor.common.enums;// Copyright (C), Created on 2021-04-03

import cn.meteor.common.interfaces.IResultType;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 统一响应枚举
 *
 * @author ths
 * @since 1.0.0
 */
@Getter
@AllArgsConstructor
public enum ResultType implements IResultType {

	/** 响应码列表 0 - 999 调用成功，内部信息不同 */
	SUCCESS(0, "成功", "响应成功"),
	NO_DATA(201, "查询成功，无数据", "查询成功，数据库无数据"),

	TOKEN_PAST(301, "登陆信息已过期，请重新登录", "token过期"),
	TOKEN_ERROR(302, "登陆信息已过期，请重新登录", "token异常"),
	LOGIN_ERROR(303, "非法登录", "登录异常"),
	REMOTE_ERROR(304, "异地登录", "异地登录"),
	TOKEN_NO(305, "未登录", "无token"),

	LOGIN_NAME(310, "用户名错误", "用户名错误"),
	LOGIN_NAME_NULL(311, "用户名为空", "用户名为空"),
	LOGIN_PASSWORD(312, "密码错误", "密码错误"),
	LOGIN_CODE(313, "验证码错误", "验证码错误"),
	LOGOUT_CODE(314, "退出失败", "退出失败，token 为空"),
	USER_PSW_ERROR(315, "用户名或密码错误", "用户名或密码错误"),
	USER_NO_ERROR(316, "用户不存在", "用户不存在"),
	USER_UPDATE_ERROR(317, "用户密码变更失败", "用户密码变更失败"),
	USER_PWS_EQUAL_ERROR(318, "新密码与原密码不能相同", "新密码与原密码不能相同"),

	CRUD_CREATE_FAIL(401, "创建失败", "创建失败，插入数量为0"),
	CRUD_MODIFY_FAIL(402, "修改失败，数据已被人变动，请刷新后再试", "修改失败，更新数量为0"),
	CRUD_REMOVE_FAIL(403, "删除失败，该数据已被删除，请刷新后查看", "删除失败，删除数据为0"),
	CRUD_FIND_FAIL(404, "查找失败，不存在该值，请刷新", "查找失败，查询数据为0"),
	CRUD_NAME_REPEAT(405, "已存在该名称", "已存在该名称"),

	CRUD_REMOVE_NOT(406, "不允许删除", "不允许删除"),
	CRUD_VALID_NOT(407, "字段校验异常", "字段校验异常"),
	CRUD_NOT_OPERATE(408, "无操作权限", "无操作权限"),
	CRUD_LOCK_OPERATE(409, "任务已执行", "分布式锁获取失败"),

	CRUD_TEST_FAIL(410, "连接失败", "连接远程数据库失败"),
	CRUD_QUERY_FAIL(411, "查询失败", "查询失败，查询数据为0"),
	CRUD_REMOVE_Non_leaf_FAIL(412, "禁止删除非叶子节点", "禁止删除非叶子节点"),

	/** 响应码列表 1000 - 1999 网关、链路、限流、熔断 架构内错误 */
	SENTINEL_DEGRADE_ERROR(1000, "当前请求人数太多，请重试", "被降级规则阻挡"),
	SENTINEL_PARAM_ERROR(1001, "当前请求人数太多，请重试", "被热点参数规则阻挡"),
	SENTINEL_SYSTEM_ERROR(1002, "当前请求人数太多，请重试", "被系统规则阻挡"),
	SENTINEL_AUTHORITY_ERROR(1003, "当前请求人数太多，请重试", "被授权规则阻挡"),
	SENTINEL_ERROR(1999, "当前请求人数太多，请重试", "Unknown"),

	/** 响应码列表 2000 - 2999 参数错误、权限不足、重复请求、脏数据、过程中  客户端导致的错误 */
	PROCESS(2000, "处理中", "请求已接收，程序处理中"),
	PARAMETER_MISSING_ERROR(2001, "填写数据不完整", "缺少必要请求参数"),
	REQUEST_MISSING_BODY_ERROR(2002, "填写数据方式不正确", "缺少请求体"),
	ACCEPT_ERROR(2003, "填写数据格式有误", "请求ACCEPT参数设置不正确"),
	NOT_ACCEPT_ERROR(2004, "填写数据格式非法", "不允许的ACCEPT参数设置"),
	CONTENT_TYPE_ERROR(2005, "填写数据格式非法", "不允许的Content-Type参数设置"),
	MESSAGE_CONVERT(2006, "填写数据类型有误", "客户端参数类型转换错误"),
	PARAMETER_ERROR(2010, "填写数据参数有误", "请求参数不正确"),

	/** 响应码列表 3000 - 3999 失败 服务端导致的错误 */
	FAILED(3000, "失败", "响应失败"),
	SERVER_FAILED(3001, "服务繁忙，请稍后重试", "服务内部错误，请链路追踪错误详情"),
	SOCKET_TIMEOUT(3002, "服务繁忙，请稍后重试", "服务器通讯超时异常"),
	SERVER_ERROR(3999, "未知错误", "服务器内部异常，未知的错误，请链路追踪排查异常"),
	;

	/** 响应码 */
	private final int code;
	/** 响应信息 */
	private final String message;
	/** 告警信息 */
	private final String warning;
}
